/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateSavedSearch
extends RedoableOp {
    private int mSearchId;
    private String mName;
    private String mQuery;
    private String mTypes;
    private String mSort;
    private int mFolderId;
    private int mFlags;
    private long mColor;

    public CreateSavedSearch() {
        this.mSearchId = 0;
    }

    public CreateSavedSearch(long mailboxId, int folderId, String name, String query, String types, String sort, int flags, MailItem.Color color) {
        this.setMailboxId(mailboxId);
        this.mSearchId = 0;
        this.mName = name != null ? name : "";
        this.mQuery = query != null ? query : "";
        this.mTypes = types != null ? query : "";
        this.mSort = sort != null ? query : "";
        this.mFolderId = folderId;
        this.mFlags = flags;
        this.mColor = color.getRgb();
    }

    public int getSearchId() {
        return this.mSearchId;
    }

    public void setSearchId(int searchId) {
        this.mSearchId = searchId;
    }

    public int getOpCode() {
        return 12;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("id=").append(this.mSearchId);
        sb.append(", name=").append(this.mName).append(", query=").append(this.mQuery);
        sb.append(", types=").append(this.mTypes).append(", sort=").append(this.mSort);
        sb.append(", flags=").append(this.mFlags);
        sb.append(", color=").append(this.mColor);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mSearchId);
        out.writeUTF(this.mName);
        out.writeUTF(this.mQuery);
        out.writeUTF(this.mTypes);
        out.writeUTF(this.mSort);
        out.writeInt(this.mFolderId);
        out.writeInt(this.mFlags);
        out.writeLong(this.mColor);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mSearchId = in.readInt();
        this.mName = in.readUTF();
        this.mQuery = in.readUTF();
        this.mTypes = in.readUTF();
        this.mSort = in.readUTF();
        this.mFolderId = in.readInt();
        this.mFlags = this.getVersion().atLeast(1, 28) ? in.readInt() : 0;
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mailbox.createSearchFolder(this.getOperationContext(), this.mFolderId, this.mName, this.mQuery, this.mTypes, this.mSort, this.mFlags, new MailItem.Color(this.mColor));
        }
        catch (MailServiceException e) {
            String code = e.getCode();
            if (code.equals("mail.ALREADY_EXISTS")) {
                if (mLog.isInfoEnabled()) {
                    mLog.info("Search " + this.mSearchId + " already exists in mailbox " + mboxId);
                }
            }
            throw e;
        }
    }
}

