/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateNote
extends RedoableOp {
    private int mId;
    private int mFolderId;
    private String mContent;
    private long mColor;
    private Note.Rectangle mBounds;

    public CreateNote() {
        this.mId = 0;
        this.mFolderId = 0;
    }

    public CreateNote(long mailboxId, int folderId, String content, MailItem.Color color, Note.Rectangle bounds) {
        this.setMailboxId(mailboxId);
        this.mId = 0;
        this.mFolderId = folderId;
        this.mContent = content != null ? content : "";
        this.mColor = color.getRgb();
        this.mBounds = bounds;
    }

    public int getNoteId() {
        return this.mId;
    }

    public void setNoteId(int id) {
        this.mId = id;
    }

    public int getOpCode() {
        return 32;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mId);
        sb.append(", folder=").append(this.mFolderId);
        sb.append(", content=").append(this.mContent);
        sb.append(", color=").append(this.mColor);
        if (this.mBounds != null) {
            sb.append(", bounds=(").append(this.mBounds).append(")");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeInt(this.mFolderId);
        out.writeShort((short)-1);
        out.writeUTF(this.mContent);
        out.writeLong(this.mColor);
        out.writeInt(this.mBounds.x);
        out.writeInt(this.mBounds.y);
        out.writeInt(this.mBounds.width);
        out.writeInt(this.mBounds.height);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mFolderId = in.readInt();
        in.readShort();
        this.mContent = in.readUTF();
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
        int x = in.readInt();
        int y = in.readInt();
        int w = in.readInt();
        int h = in.readInt();
        this.mBounds = new Note.Rectangle(x, y, w, h);
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mailbox.createNote(this.getOperationContext(), this.mContent, this.mBounds, new MailItem.Color(this.mColor), this.mFolderId);
        }
        catch (MailServiceException e) {
            String code = e.getCode();
            if (code.equals("mail.ALREADY_EXISTS")) {
                if (mLog.isInfoEnabled()) {
                    mLog.info("Note " + this.mId + " already exists in mailbox " + mboxId);
                }
            }
            throw e;
        }
    }
}

