/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateMountpoint
extends RedoableOp {
    private int mId;
    private int mFolderId;
    private String mName;
    private String mOwnerId;
    private int mRemoteId;
    private byte mDefaultView;
    private int mFlags;
    private long mColor;

    public CreateMountpoint() {
        this.mId = 0;
    }

    public CreateMountpoint(long mailboxId, int folderId, String name, String ownerId, int remoteId, byte view, int flags, MailItem.Color color) {
        this.setMailboxId(mailboxId);
        this.mId = 0;
        this.mFolderId = folderId;
        this.mName = name != null ? name : "";
        this.mOwnerId = ownerId;
        this.mRemoteId = remoteId;
        this.mDefaultView = view;
        this.mFlags = flags;
        this.mColor = color.getRgb();
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id) {
        this.mId = id;
    }

    public int getOpCode() {
        return 35;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("id=").append(this.mId);
        sb.append(", name=").append(this.mName).append(", folder=").append(this.mFolderId);
        sb.append(", owner=").append(this.mOwnerId).append(", remote=").append(this.mRemoteId);
        sb.append(", view=").append(this.mDefaultView).append(", flags=").append(this.mFlags).append(", color=").append(this.mColor);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeUTF(this.mName);
        out.writeUTF(this.mOwnerId);
        out.writeInt(this.mRemoteId);
        out.writeInt(this.mFolderId);
        out.writeByte(this.mDefaultView);
        out.writeInt(this.mFlags);
        out.writeLong(this.mColor);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mName = in.readUTF();
        this.mOwnerId = in.readUTF();
        this.mRemoteId = in.readInt();
        this.mFolderId = in.readInt();
        this.mDefaultView = in.readByte();
        this.mFlags = in.readInt();
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mailbox.createMountpoint(this.getOperationContext(), this.mFolderId, this.mName, this.mOwnerId, this.mRemoteId, this.mDefaultView, this.mFlags, new MailItem.Color(this.mColor));
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.ALREADY_EXISTS") {
                if (mLog.isInfoEnabled()) {
                    mLog.info("Mount " + this.mId + " already exists in mailbox " + mboxId);
                }
            }
            throw e;
        }
    }
}

