/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.mime.ParsedMessageOptions;
import com.zimbra.cs.redolog.RedoException;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.CreateCalendarItemRecorder;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.RedoableOpData;
import com.zimbra.cs.redolog.op.StoreIncomingBlob;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StorageCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import javax.activation.DataSource;

public class CreateMessage
extends RedoableOp
implements CreateCalendarItemPlayer,
CreateCalendarItemRecorder {
    private static final long RECEIVED_DATE_UNSET = -1L;
    private static final byte MSGBODY_INLINE = 1;
    private static final byte MSGBODY_LINK = 2;
    private long mReceivedDate;
    private String mRcptEmail;
    private boolean mShared;
    private String mDigest;
    protected int mMsgSize;
    private int mMsgId;
    private int mFolderId;
    private int mConvId;
    private int mConvFirstMsgId;
    private int mFlags;
    private String mTags;
    private int mCalendarItemId;
    private String mCalendarItemPartStat = "NE";
    private boolean mNoICal;
    private MailItem.CustomMetadata mExtendedData;
    protected RedoableOpData mData;
    private byte mMsgBodyType;
    private String mPath;

    public CreateMessage() {
        this.mShared = false;
        this.mMsgId = 0;
        this.mFolderId = 0;
        this.mConvId = 0;
        this.mConvFirstMsgId = 0;
        this.mFlags = 0;
        this.mMsgBodyType = 1;
        this.mNoICal = false;
    }

    protected CreateMessage(long mailboxId, String rcptEmail, boolean shared, String digest, int msgSize, int folderId, boolean noICal, int flags, String tags) {
        this(mailboxId, rcptEmail, -1L, shared, digest, msgSize, folderId, noICal, flags, tags, null);
    }

    public CreateMessage(long mailboxId, String rcptEmail, long receivedDate, boolean shared, String digest, int msgSize, int folderId, boolean noICal, int flags, String tags, MailItem.CustomMetadata extended) {
        this.setMailboxId(mailboxId);
        this.mRcptEmail = rcptEmail;
        this.mReceivedDate = receivedDate;
        this.mShared = shared;
        this.mDigest = digest != null ? digest : "";
        this.mMsgSize = msgSize;
        this.mMsgId = 0;
        this.mFolderId = folderId;
        this.mConvId = 0;
        this.mConvFirstMsgId = 0;
        this.mFlags = flags;
        this.mTags = tags != null ? tags : "";
        this.mMsgBodyType = 1;
        this.mNoICal = noICal;
        this.mExtendedData = extended;
    }

    public void start(long timestamp) {
        super.start(timestamp);
        if (this.mReceivedDate == -1L) {
            this.mReceivedDate = timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        try {
            super.commit();
            Object var2_1 = null;
            this.mData = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mData = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        try {
            super.abort();
            Object var2_1 = null;
            this.mData = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mData = null;
            throw throwable;
        }
    }

    public int getMessageId() {
        return this.mMsgId;
    }

    public void setMessageId(int msgId) {
        this.mMsgId = msgId;
    }

    public int getConvId() {
        return this.mConvId;
    }

    public void setConvId(int convId) {
        this.mConvId = convId;
    }

    public int getConvFirstMsgId() {
        return this.mConvFirstMsgId;
    }

    public void setConvFirstMsgId(int convFirstMsgId) {
        this.mConvFirstMsgId = convFirstMsgId;
    }

    public void setCalendarItemAttrs(int calItemId, int folderId) {
        this.mCalendarItemId = calItemId;
        this.mFolderId = folderId;
    }

    public int getCalendarItemId() {
        return this.mCalendarItemId;
    }

    public String getCalendarItemPartStat() {
        return this.mCalendarItemPartStat;
    }

    public void setCalendarItemPartStat(String partStat) {
        this.mCalendarItemPartStat = partStat;
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public String getTags() {
        return this.mTags;
    }

    public int getOpCode() {
        return 27;
    }

    public byte[] getMessageBody() throws IOException {
        if (this.mMsgBodyType == 2) {
            return null;
        }
        return this.mData.getData();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setMessageBodyInfo(DataSource ds, long size) {
        this.mMsgBodyType = 1;
        this.mData = new RedoableOpData(ds, (int)size);
        this.mPath = ":streamed:";
    }

    public void setMessageBodyInfo(File dataFile) {
        this.mMsgBodyType = 1;
        this.mData = new RedoableOpData(dataFile);
        this.mPath = dataFile.getPath();
    }

    public void setMessageLinkInfo(String linkSrcPath) {
        this.mMsgBodyType = (byte)2;
        assert (linkSrcPath != null);
        this.mPath = linkSrcPath;
    }

    public String getRcptEmail() {
        return this.mRcptEmail;
    }

    protected RedoableOpData getData() {
        return this.mData;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("id=").append(this.mMsgId);
        sb.append(", rcpt=").append(this.mRcptEmail);
        sb.append(", rcvDate=").append(this.mReceivedDate);
        sb.append(", shared=").append(this.mShared ? "true" : "false");
        sb.append(", blobDigest=\"").append(this.mDigest).append("\", size=").append(this.mMsgSize);
        if (this.mData != null) {
            sb.append(", dataLen=").append(this.mData.getLength());
        }
        sb.append(", folder=").append(this.mFolderId);
        sb.append(", conv=").append(this.mConvId);
        sb.append(", convFirstMsgId=").append(this.mConvFirstMsgId);
        if (this.mCalendarItemId != 0) {
            sb.append(", calItemId=").append(this.mCalendarItemId);
        }
        sb.append(", calItemPartStat=").append(this.mCalendarItemPartStat);
        sb.append(", noICal=").append(this.mNoICal);
        if (this.mExtendedData != null) {
            sb.append(", extended=").append(this.mExtendedData);
        }
        sb.append(", flags=").append(this.mFlags).append(", tags=\"").append(this.mTags).append("\"");
        sb.append(", bodyType=").append(this.mMsgBodyType);
        if (this.mMsgBodyType == 2) {
            sb.append(", linkSourcePath=").append(this.mPath);
        } else {
            sb.append(", path=").append(this.mPath);
        }
        return sb.toString();
    }

    public InputStream getAdditionalDataStream() throws IOException {
        if (this.mMsgBodyType == 1) {
            return this.mData.getInputStream();
        }
        return null;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mRcptEmail != null ? this.mRcptEmail : "");
        if (this.getVersion().atLeast(1, 4)) {
            out.writeLong(this.mReceivedDate);
        }
        out.writeBoolean(this.mShared);
        out.writeUTF(this.mDigest);
        out.writeInt(this.mMsgSize);
        out.writeInt(this.mMsgId);
        out.writeInt(this.mFolderId);
        out.writeInt(this.mConvId);
        if (this.getVersion().atLeast(1, 5)) {
            out.writeInt(this.mConvFirstMsgId);
        }
        out.writeInt(this.mCalendarItemId);
        if (this.getVersion().atLeast(1, 1)) {
            out.writeUTF(this.mCalendarItemPartStat);
        }
        out.writeInt(this.mFlags);
        out.writeBoolean(this.mNoICal);
        out.writeUTF(this.mTags);
        out.writeUTF(this.mPath);
        out.writeShort((short)-1);
        if (this.getVersion().atLeast(1, 25)) {
            if (this.mExtendedData == null) {
                out.writeUTF(null);
            } else {
                out.writeUTF(this.mExtendedData.getSectionKey());
                out.writeUTF(this.mExtendedData.getSerializedValue());
            }
        }
        out.writeByte(this.mMsgBodyType);
        if (this.mMsgBodyType == 1) {
            out.writeInt(this.mData.getLength());
        } else {
            out.writeShort((short)-1);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mRcptEmail = in.readUTF();
        this.mReceivedDate = this.getVersion().atLeast(1, 4) ? in.readLong() : this.getTimestamp();
        this.mShared = in.readBoolean();
        this.mDigest = in.readUTF();
        this.mMsgSize = in.readInt();
        this.mMsgId = in.readInt();
        this.mFolderId = in.readInt();
        this.mConvId = in.readInt();
        if (this.getVersion().atLeast(1, 5)) {
            this.mConvFirstMsgId = in.readInt();
        }
        this.mCalendarItemId = in.readInt();
        if (this.getVersion().atLeast(1, 1)) {
            this.mCalendarItemPartStat = in.readUTF();
        }
        this.mFlags = in.readInt();
        this.mNoICal = in.readBoolean();
        this.mTags = in.readUTF();
        this.mPath = in.readUTF();
        in.readShort();
        if (this.getVersion().atLeast(1, 25)) {
            this.mExtendedData = null;
            String extendedKey = in.readUTF();
            if (extendedKey != null) {
                this.mExtendedData = new MailItem.CustomMetadata(extendedKey, in.readUTF());
            }
        }
        this.mMsgBodyType = in.readByte();
        if (this.mMsgBodyType == 1) {
            int dataLength = in.readInt();
            boolean inMemory = false;
            try {
                inMemory = dataLength <= StorageCallback.getDiskStreamingThreshold();
            }
            catch (ServiceException e) {
                // empty catch block
            }
            if (inMemory) {
                byte[] data = new byte[dataLength];
                in.readFully(data, 0, dataLength);
                this.mData = new RedoableOpData(data);
            } else {
                long pos = in.getFilePointer();
                this.mData = new RedoableOpData(new File(in.getPath()), pos, dataLength);
                int numSkipped = in.skipBytes(dataLength);
                if (numSkipped != dataLength) {
                    String msg = String.format("Attempted to skip %d bytes at position %d in %s, but actually skipped %d.", dataLength, pos, in.getPath(), numSkipped);
                    throw new IOException(msg);
                }
            }
        } else {
            in.readShort();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        DeliveryContext deliveryCtxt = new DeliveryContext(this.mShared, Arrays.asList(mboxId));
        if (this.mMsgBodyType == 2) {
            Blob blob = StoreIncomingBlob.fetchBlob(this.mPath);
            if (blob == null) {
                throw new RedoException("Missing link source blob " + this.mPath + " (digest=" + this.mDigest + ")", this);
            }
            deliveryCtxt.setIncomingBlob(blob);
            ParsedMessage pm = null;
            try {
                try {
                    ParsedMessageOptions opt = new ParsedMessageOptions().setContent(blob.getFile()).setReceivedDate(this.mReceivedDate).setAttachmentIndexing(mbox.attachmentsIndexingEnabled()).setSize(this.mMsgSize).setDigest(this.mDigest);
                    pm = new ParsedMessage(opt);
                    mbox.addMessage(this.getOperationContext(), pm, this.mFolderId, this.mNoICal, this.mFlags, this.mTags, this.mConvId, this.mRcptEmail, this.mExtendedData, deliveryCtxt);
                }
                catch (MailServiceException e) {
                    if (e.getCode() != "mail.ALREADY_EXISTS") throw e;
                    mLog.info("Message " + this.mMsgId + " is already in mailbox " + mboxId);
                    Object var9_11 = null;
                    if (pm == null) return;
                    ByteUtil.closeStream(pm.getBlobInputStream());
                    return;
                }
                Object var9_10 = null;
                if (pm == null) return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (pm == null) throw throwable;
                ByteUtil.closeStream(pm.getBlobInputStream());
                throw throwable;
            }
            ByteUtil.closeStream(pm.getBlobInputStream());
            return;
        }
        InputStream in = null;
        try {
            try {
                in = this.mData.getInputStream();
                if (this.mData.getLength() != this.mMsgSize) {
                    in = new GZIPInputStream(in);
                }
                mbox.addMessage(this.getOperationContext(), in, this.mMsgSize, this.mReceivedDate, this.mFolderId, this.mNoICal, this.mFlags, this.mTags, this.mConvId, this.mRcptEmail, this.mExtendedData, deliveryCtxt);
            }
            catch (MailServiceException e) {
                if (e.getCode() != "mail.ALREADY_EXISTS") throw e;
                mLog.info("Message " + this.mMsgId + " is already in mailbox " + mboxId);
                Object var11_15 = null;
                ByteUtil.closeStream(in);
                return;
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }
}

