/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.MailboxIdConflictException;
import com.zimbra.cs.redolog.RedoException;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateMailbox
extends RedoableOp {
    private String mAccountId;

    public CreateMailbox() {
    }

    public CreateMailbox(String accountId) {
        this.mAccountId = accountId;
    }

    public int getOpCode() {
        return 7;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("account=").append(this.mAccountId != null ? this.mAccountId : "");
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mAccountId);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mAccountId = in.readUTF();
    }

    public void redo() throws Exception {
        long opMboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.mAccountId, false);
        if (mbox != null) {
            long mboxId = mbox.getId();
            if (opMboxId == mboxId) {
                mLog.info("Mailbox " + opMboxId + " for account " + this.mAccountId + " already exists");
                return;
            }
            throw new MailboxIdConflictException(this.mAccountId, opMboxId, mboxId, this);
        }
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mAccountId);
        if (account == null) {
            throw new RedoException("Account " + this.mAccountId + " does not exist", this);
        }
        mbox = MailboxManager.getInstance().createMailbox(this.getOperationContext(), account);
    }
}

