/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.CreateCalendarItemRecorder;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateInvite
extends RedoableOp
implements CreateCalendarItemRecorder,
CreateCalendarItemPlayer {
    private int mCalendarItemId;
    private String mCalendarItemPartStat = "NE";
    private Invite mInvite;
    private int mFolderId;
    private byte[] mData;
    private boolean mPreserveExistingAlarms;
    private boolean mDiscardExistingInvites;
    private boolean mAddRevision;

    public CreateInvite() {
    }

    public CreateInvite(long mailboxId, Invite inv, int folderId, byte[] data, boolean preserveExistingAlarms, boolean discardExistingInvites, boolean addRevision) {
        this.setMailboxId(mailboxId);
        this.mInvite = inv;
        this.mFolderId = folderId;
        this.mData = data;
        this.mPreserveExistingAlarms = preserveExistingAlarms;
        this.mDiscardExistingInvites = discardExistingInvites;
        this.mAddRevision = addRevision;
    }

    public int getOpCode() {
        return 43;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("calItemId=").append(this.mCalendarItemId);
        sb.append(", calItemPartStat=").append(this.mCalendarItemPartStat);
        sb.append(", folder=").append(this.mFolderId);
        sb.append(", dataLen=").append(this.mData != null ? this.mData.length : 0);
        ICalTimeZone localTz = this.mInvite.getTimeZoneMap().getLocalTimeZone();
        sb.append(", localTZ=").append(localTz.encodeAsMetadata().toString());
        sb.append(", inv=").append(Invite.encodeMetadata(this.mInvite).toString());
        sb.append(", preserveExistingAlarms=").append(this.mPreserveExistingAlarms);
        sb.append(", discardExistingInvites=").append(this.mDiscardExistingInvites);
        sb.append(", addRevision=").append(this.mAddRevision);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mCalendarItemId);
        if (this.getVersion().atLeast(1, 1)) {
            out.writeUTF(this.mCalendarItemPartStat);
        }
        out.writeInt(this.mFolderId);
        if (this.getVersion().atLeast(1, 0)) {
            out.writeShort((short)-1);
        }
        out.writeBoolean(true);
        int dataLen = this.mData != null ? this.mData.length : 0;
        out.writeInt(dataLen);
        if (dataLen > 0) {
            out.write(this.mData);
        }
        ICalTimeZone localTz = this.mInvite.getTimeZoneMap().getLocalTimeZone();
        out.writeUTF(localTz.encodeAsMetadata().toString());
        out.writeUTF(Invite.encodeMetadata(this.mInvite).toString());
        if (this.getVersion().atLeast(1, 22)) {
            out.writeBoolean(this.mPreserveExistingAlarms);
            out.writeBoolean(this.mDiscardExistingInvites);
        }
        if (this.getVersion().atLeast(1, 23)) {
            out.writeBoolean(this.mAddRevision);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mCalendarItemId = in.readInt();
        if (this.getVersion().atLeast(1, 1)) {
            this.mCalendarItemPartStat = in.readUTF();
        }
        this.mFolderId = in.readInt();
        if (this.getVersion().atLeast(1, 0)) {
            in.readShort();
        }
        in.readBoolean();
        int dataLen = in.readInt();
        if (dataLen > 0) {
            this.mData = new byte[dataLen];
            in.readFully(this.mData);
        }
        try {
            ICalTimeZone localTz = ICalTimeZone.decodeFromMetadata(new Metadata(in.readUTF()));
            this.mInvite = Invite.decodeMetadata(this.getMailboxId(), new Metadata(in.readUTF()), null, localTz);
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            throw new IOException("Cannot read serialized entry for CreateInvite " + ex.toString());
        }
        if (this.getVersion().atLeast(1, 22)) {
            this.mPreserveExistingAlarms = in.readBoolean();
            this.mDiscardExistingInvites = in.readBoolean();
        } else {
            this.mPreserveExistingAlarms = false;
            this.mDiscardExistingInvites = false;
        }
        this.mAddRevision = this.getVersion().atLeast(1, 23) ? in.readBoolean() : false;
    }

    public void setCalendarItemAttrs(int appointmentId, int folderId) {
        this.mCalendarItemId = appointmentId;
        this.mFolderId = folderId;
    }

    public int getCalendarItemId() {
        return this.mCalendarItemId;
    }

    public String getCalendarItemPartStat() {
        return this.mCalendarItemPartStat;
    }

    public void setCalendarItemPartStat(String partStat) {
        this.mCalendarItemPartStat = partStat;
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        ParsedMessage pm = null;
        if (this.mData != null && this.mData.length > 0) {
            pm = new ParsedMessage(this.mData, (Long)this.getTimestamp(), mbox.attachmentsIndexingEnabled());
        }
        mbox.addInvite(this.getOperationContext(), this.mInvite, this.mFolderId, pm, this.mPreserveExistingAlarms, this.mDiscardExistingInvites, this.mAddRevision);
    }
}

