/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateFolderPath
extends RedoableOp {
    private String mPath;
    private byte mAttrs;
    private byte mDefaultView;
    private int mFlags;
    private long mColor;
    private String mUrl;
    private int[] mFolderIds;

    public CreateFolderPath() {
    }

    public CreateFolderPath(long mailboxId, String name, byte attrs, byte view, int flags, MailItem.Color color, String url) {
        this.setMailboxId(mailboxId);
        this.mPath = name == null ? "" : name;
        this.mAttrs = attrs;
        this.mDefaultView = view;
        this.mFlags = flags;
        this.mColor = color.getRgb();
        this.mUrl = url == null ? "" : url;
    }

    public int[] getFolderIds() {
        return this.mFolderIds;
    }

    public void setFolderIds(int[] parentIds) {
        this.mFolderIds = parentIds;
    }

    public int getOpCode() {
        return 23;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("name=").append(this.mPath);
        sb.append(", attrs=").append(this.mAttrs).append(", view=").append(this.mDefaultView);
        sb.append(", flags=").append(this.mFlags).append(", color=").append(this.mColor);
        sb.append(", url=").append(this.mUrl);
        if (this.mFolderIds != null) {
            sb.append(", folderIds=[");
            for (int i = 0; i < this.mFolderIds.length; ++i) {
                sb.append(this.mFolderIds[i]);
                if (i >= this.mFolderIds.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mPath);
        out.writeByte(this.mAttrs);
        out.writeByte(this.mDefaultView);
        out.writeInt(this.mFlags);
        out.writeLong(this.mColor);
        out.writeUTF(this.mUrl);
        if (this.mFolderIds != null) {
            out.writeInt(this.mFolderIds.length);
            for (int i = 0; i < this.mFolderIds.length; ++i) {
                out.writeInt(this.mFolderIds[i]);
            }
        } else {
            out.writeInt(0);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mPath = in.readUTF();
        this.mAttrs = in.readByte();
        this.mDefaultView = in.readByte();
        this.mFlags = in.readInt();
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
        this.mUrl = in.readUTF();
        int numParentIds = in.readInt();
        if (numParentIds > 0) {
            this.mFolderIds = new int[numParentIds];
            for (int i = 0; i < numParentIds; ++i) {
                this.mFolderIds[i] = in.readInt();
            }
        }
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mailbox.createFolder(this.getOperationContext(), this.mPath, this.mAttrs, this.mDefaultView, this.mFlags, new MailItem.Color(this.mColor), this.mUrl);
        }
        catch (MailServiceException e) {
            String code = e.getCode();
            if (code.equals("mail.ALREADY_EXISTS")) {
                if (mLog.isInfoEnabled()) {
                    mLog.info("Folder " + this.mPath + " already exists in mailbox " + mboxId);
                }
            }
            throw e;
        }
    }
}

