/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateFolder
extends RedoableOp {
    private String mName;
    private int mParentId;
    private byte mAttrs;
    private byte mDefaultView;
    private int mFlags;
    private long mColor;
    private String mUrl;
    private int mFolderId;

    public CreateFolder() {
    }

    public CreateFolder(long mailboxId, String name, int parentId, byte view, int flags, MailItem.Color color, String url) {
        this(mailboxId, name, parentId, 0, view, flags, color, url);
    }

    public CreateFolder(long mailboxId, String name, int parentId, byte attrs, byte view, int flags, MailItem.Color color, String url) {
        this.setMailboxId(mailboxId);
        this.mName = name == null ? "" : name;
        this.mParentId = parentId;
        this.mAttrs = attrs;
        this.mDefaultView = view;
        this.mFlags = flags;
        this.mColor = color.getRgb();
        this.mUrl = url == null ? "" : url;
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public void setFolderId(int folderId) {
        this.mFolderId = folderId;
    }

    public int getOpCode() {
        return 58;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("name=").append(this.mName);
        sb.append(", parent=").append(this.mParentId);
        sb.append(", attrs=").append(this.mAttrs);
        sb.append(", view=").append(this.mDefaultView);
        sb.append(", flags=").append(this.mFlags).append(", color=").append(this.mColor);
        sb.append(", url=").append(this.mUrl).append(", id=").append(this.mFolderId);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mName);
        out.writeInt(this.mParentId);
        if (this.getVersion().atLeast(1, 19)) {
            out.writeByte(this.mAttrs);
        }
        out.writeByte(this.mDefaultView);
        out.writeInt(this.mFlags);
        out.writeLong(this.mColor);
        out.writeUTF(this.mUrl);
        out.writeInt(this.mFolderId);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mName = in.readUTF();
        this.mParentId = in.readInt();
        if (this.getVersion().atLeast(1, 19)) {
            this.mAttrs = in.readByte();
        }
        this.mDefaultView = in.readByte();
        this.mFlags = in.readInt();
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
        this.mUrl = in.readUTF();
        this.mFolderId = in.readInt();
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mailbox.createFolder(this.getOperationContext(), this.mName, this.mParentId, this.mAttrs, this.mDefaultView, this.mFlags, new MailItem.Color(this.mColor), this.mUrl);
        }
        catch (MailServiceException e) {
            String code = e.getCode();
            if (code.equals("mail.ALREADY_EXISTS")) {
                if (mLog.isInfoEnabled()) {
                    mLog.info("Folder " + this.mName + " already exists in mailbox " + mboxId);
                }
            }
            throw e;
        }
    }
}

