/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.RedoableOpData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class CreateContact
extends RedoableOp {
    private int mId;
    private int mFolderId;
    private Map<String, String> mFields;
    private ParsedContact mParsedContact;
    private RedoableOpData mRedoLogContent;
    private String mTags;

    public CreateContact() {
        this.mId = 0;
        this.mFolderId = 0;
    }

    public CreateContact(long mailboxId, int folderId, ParsedContact pc, String tags) {
        this.setMailboxId(mailboxId);
        this.mId = 0;
        this.mFolderId = folderId;
        this.mFields = pc.getFields();
        this.mParsedContact = pc;
        this.mTags = tags != null ? tags : "";
    }

    public void setContactId(int id) {
        this.mId = id;
    }

    public int getContactId() {
        return this.mId;
    }

    public int getOpCode() {
        return 30;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("folder=").append(this.mFolderId);
        sb.append(", tags=\"").append(this.mTags).append("\"");
        if (this.mFields != null && this.mFields.size() > 0) {
            sb.append(", attrs={");
            for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append("\n    ").append(key).append(": ").append(value);
            }
            sb.append("\n}");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeInt(this.mFolderId);
        out.writeShort((short)-1);
        out.writeUTF(this.mTags);
        int numAttrs = this.mFields != null ? this.mFields.size() : 0;
        out.writeShort((short)numAttrs);
        if (numAttrs > 0) {
            for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
                out.writeUTF(entry.getKey());
                String value = entry.getValue();
                out.writeUTF(value != null ? value : "");
            }
        }
        if (this.getVersion().atLeast(1, 14)) {
            out.writeInt((int)this.mParsedContact.getSize());
        }
    }

    public InputStream getAdditionalDataStream() throws IOException {
        if (this.getVersion().atLeast(1, 14)) {
            if (this.mParsedContact != null) {
                return this.mParsedContact.getContentStream();
            }
            if (this.mRedoLogContent != null) {
                return this.mRedoLogContent.getInputStream();
            }
        }
        return null;
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mFolderId = in.readInt();
        in.readShort();
        this.mTags = in.readUTF();
        int numAttrs = in.readShort();
        if (numAttrs > 0) {
            this.mFields = new HashMap<String, String>(numAttrs);
            for (int i = 0; i < numAttrs; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                this.mFields.put(key, value);
            }
        }
        if (this.getVersion().atLeast(1, 14)) {
            int length = in.readInt();
            if (length > 0x6400000) {
                throw new IOException("deserialized message size too large (" + length + " bytes)");
            }
            if (length > 0) {
                this.mRedoLogContent = new RedoableOpData(new File(in.getPath()), in.getFilePointer(), length);
                long pos = in.getFilePointer();
                int numSkipped = in.skipBytes(length);
                if (numSkipped != length) {
                    String msg = String.format("Attempted to skip %d bytes at position %d in %s, but actually skipped %d.", length, pos, in.getPath(), numSkipped);
                    throw new IOException(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        InputStream in = null;
        try {
            try {
                in = this.getAdditionalDataStream();
                ParsedContact pc = new ParsedContact(this.mFields, in);
                mailbox.createContact(this.getOperationContext(), pc, this.mFolderId, this.mTags);
            }
            catch (ServiceException e) {
                String code = e.getCode();
                if (!code.equals("mail.ALREADY_EXISTS")) throw e;
                if (mLog.isInfoEnabled()) {
                    mLog.info("Contact " + this.mId + " already exists in mailbox " + mboxId);
                }
                Object var8_7 = null;
                ByteUtil.closeStream(in);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }
}

