/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateMessage;
import java.io.IOException;

public class CreateChat
extends CreateMessage {
    public CreateChat() {
    }

    public CreateChat(long mailboxId, String digest, int msgSize, int folderId, int flags, String tags) {
        super(mailboxId, ":API:", false, digest, msgSize, folderId, true, flags, tags);
    }

    public int getOpCode() {
        return 63;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        super.serializeData(out);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        super.deserializeData(in);
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        ParsedMessage pm = new ParsedMessage(this.getMessageBody(), (Long)this.getTimestamp(), mbox.attachmentsIndexingEnabled());
        try {
            mbox.createChat(this.getOperationContext(), pm, this.getFolderId(), this.getFlags(), this.getTags());
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.ALREADY_EXISTS") {
                mLog.info("Chat " + this.getMessageId() + " is already in mailbox " + mboxId);
                return;
            }
            throw e;
        }
    }
}

