/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CopyItem
extends RedoableOp {
    private Map<Integer, Integer> mDestIds = new HashMap<Integer, Integer>();
    private byte mType;
    private int mDestFolderId;

    public CopyItem() {
        this.mType = (byte)-1;
        this.mDestFolderId = 0;
    }

    public CopyItem(long mailboxId, byte type, int folderId) {
        this.setMailboxId(mailboxId);
        this.mType = type;
        this.mDestFolderId = folderId;
    }

    public void setDestId(int srcId, int destId) {
        this.mDestIds.put(srcId, destId);
    }

    public int getDestId(int srcId) {
        Integer destId = this.mDestIds.get(srcId);
        return destId == null ? -1 : destId;
    }

    public int getOpCode() {
        return 22;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("type=").append(this.mType);
        sb.append(", destFolder=").append(this.mDestFolderId);
        sb.append(", [srcId, destId, srcImap]=");
        for (Map.Entry<Integer, Integer> entry : this.mDestIds.entrySet()) {
            sb.append('[').append(entry.getKey()).append(',').append(entry.getValue()).append(']');
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(-1);
        out.writeInt(-1);
        out.writeByte(this.mType);
        out.writeInt(this.mDestFolderId);
        out.writeShort((short)-1);
        out.writeInt(this.mDestIds.size());
        for (Map.Entry<Integer, Integer> entry : this.mDestIds.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int srcId = in.readInt();
        int destId = in.readInt();
        if (srcId > 0 && destId > 0) {
            this.mDestIds.put(srcId, destId);
        }
        this.mType = in.readByte();
        this.mDestFolderId = in.readInt();
        in.readShort();
        if (this.mDestIds.isEmpty()) {
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                srcId = in.readInt();
                this.mDestIds.put(srcId, in.readInt());
            }
        }
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        int i = 0;
        int[] itemIds = new int[this.mDestIds.size()];
        for (int id : this.mDestIds.keySet()) {
            itemIds[i++] = id;
        }
        try {
            mbox.copy(this.getOperationContext(), itemIds, this.mType, this.mDestFolderId);
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.ALREADY_EXISTS") {
                mLog.info("Item is already in mailbox " + mboxId);
                return;
            }
            throw e;
        }
    }
}

