/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.Arrays;

public class ColorItem
extends RedoableOp {
    private int[] mIds;
    private byte mType;
    private long mColor;

    public ColorItem() {
    }

    public ColorItem(long mailboxId, int[] ids, byte type, MailItem.Color color) {
        this.setMailboxId(mailboxId);
        this.mIds = ids;
        this.mType = type;
        this.mColor = color.getRgb();
    }

    public int getOpCode() {
        return 16;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(Arrays.toString(this.mIds)).append(", color=").append(this.mColor);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(-1);
        out.writeByte(this.mType);
        out.writeLong(this.mColor);
        out.writeInt(this.mIds == null ? 0 : this.mIds.length);
        if (this.mIds != null) {
            for (int i = 0; i < this.mIds.length; ++i) {
                out.writeInt(this.mIds[i]);
            }
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int id = in.readInt();
        if (id > 0) {
            this.mIds = new int[]{id};
        }
        this.mType = in.readByte();
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
        if (id <= 0) {
            this.mIds = new int[in.readInt()];
            for (int i = 0; i < this.mIds.length; ++i) {
                this.mIds[i] = in.readInt();
            }
        }
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        mailbox.setColor(this.getOperationContext(), this.mIds, this.mType, new MailItem.Color(this.mColor));
    }
}

