/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.TransactionId;
import com.zimbra.cs.redolog.op.ControlOp;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checkpoint
extends ControlOp {
    LinkedHashSet<TransactionId> mTxnSet;

    public Checkpoint() {
        this.mTxnSet = new LinkedHashSet();
    }

    public Checkpoint(LinkedHashSet<TransactionId> txns) {
        this.mTxnSet = txns;
        this.setTransactionId(new TransactionId());
    }

    public int getNumActiveTxns() {
        return this.mTxnSet.size();
    }

    public Set getActiveTxns() {
        return this.mTxnSet;
    }

    @Override
    public void log() {
    }

    @Override
    public int getOpCode() {
        return 1;
    }

    @Override
    protected String getPrintableData() {
        if (this.mTxnSet.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mTxnSet.size()).append(" active txns: ");
            int i = 0;
            for (TransactionId txn : this.mTxnSet) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(txn.toString());
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mTxnSet.size());
        for (TransactionId txn : this.mTxnSet) {
            txn.serialize(out);
        }
    }

    @Override
    protected void deserializeData(RedoLogInput in) throws IOException {
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            TransactionId txn = new TransactionId();
            txn.deserialize(in);
            this.mTxnSet.add(txn);
        }
    }
}

