/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class BackupMailbox
extends RedoableOp {
    private long mBackupSetTstamp;
    private long mStartTime;
    private long mEndTime;
    private String mLabel;

    public BackupMailbox() {
    }

    public BackupMailbox(long mailboxId, long backupSetTstamp, long startTime, long endTime, String label) {
        this.setMailboxId(mailboxId);
        this.mBackupSetTstamp = backupSetTstamp;
        this.mStartTime = startTime;
        this.mEndTime = endTime;
        this.mLabel = label;
    }

    public int getOpCode() {
        return 9;
    }

    public void redo() throws Exception {
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("backupSetTstamp=");
        sb.append(this.mBackupSetTstamp).append(", startTime=").append(this.mStartTime);
        sb.append(", endTime=").append(this.mEndTime);
        if (this.mLabel != null) {
            sb.append("label=\"").append(this.mLabel).append("\"");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeLong(this.mBackupSetTstamp);
        out.writeLong(this.mStartTime);
        out.writeLong(this.mEndTime);
        out.writeUTF(this.mLabel != null ? this.mLabel : "");
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mBackupSetTstamp = in.readLong();
        this.mStartTime = in.readLong();
        this.mEndTime = in.readLong();
        this.mLabel = in.readUTF();
    }
}

