/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.Arrays;

public class AlterItemTag
extends RedoableOp {
    private int[] mIds;
    private byte mType;
    private int mTagId;
    private boolean mTagged;
    private String mConstraint;

    public AlterItemTag() {
        this.mType = (byte)-1;
        this.mTagId = 0;
        this.mTagged = false;
        this.mConstraint = null;
    }

    public AlterItemTag(long mailboxId, int[] ids, byte type, int tagId, boolean tagged, MailItem.TargetConstraint tcon) {
        this.setMailboxId(mailboxId);
        this.mIds = ids;
        this.mType = type;
        this.mTagId = tagId;
        this.mTagged = tagged;
        this.mConstraint = tcon == null ? null : tcon.toString();
    }

    public int getOpCode() {
        return 18;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("ids=");
        sb.append(Arrays.toString(this.mIds)).append(", type=").append(this.mType);
        sb.append(", tag=").append(this.mTagId).append(", tagged=").append(this.mTagged);
        if (this.mConstraint != null) {
            sb.append(", constraint=").append(this.mConstraint);
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        boolean hasConstraint = this.mConstraint != null;
        out.writeInt(-1);
        out.writeByte(this.mType);
        out.writeInt(this.mTagId);
        out.writeBoolean(this.mTagged);
        out.writeBoolean(hasConstraint);
        if (hasConstraint) {
            out.writeUTF(this.mConstraint);
        }
        out.writeInt(this.mIds == null ? 0 : this.mIds.length);
        if (this.mIds != null) {
            for (int i = 0; i < this.mIds.length; ++i) {
                out.writeInt(this.mIds[i]);
            }
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int id = in.readInt();
        if (id > 0) {
            this.mIds = new int[]{id};
        }
        this.mType = in.readByte();
        this.mTagId = in.readInt();
        this.mTagged = in.readBoolean();
        if (in.readBoolean()) {
            this.mConstraint = in.readUTF();
        }
        if (id <= 0) {
            this.mIds = new int[in.readInt()];
            for (int i = 0; i < this.mIds.length; ++i) {
                this.mIds[i] = in.readInt();
            }
        }
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        MailItem.TargetConstraint tcon = null;
        if (this.mConstraint != null) {
            try {
                tcon = MailItem.TargetConstraint.parseConstraint(mbox, this.mConstraint);
            }
            catch (ServiceException e) {
                mLog.warn(e);
            }
        }
        mbox.alterTag(this.getOperationContext(), this.mIds, this.mType, this.mTagId, this.mTagged, tcon);
    }
}

