/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.SaveDocument;
import java.io.IOException;

public class AddDocumentRevision
extends SaveDocument {
    private int mDocId;

    public AddDocumentRevision() {
    }

    public AddDocumentRevision(long mailboxId, String digest, int msgSize, int folderId) {
        super(mailboxId, digest, msgSize, folderId);
    }

    public int getOpCode() {
        return 54;
    }

    public void setDocId(int docId) {
        this.mDocId = docId;
    }

    public int getDocId() {
        return this.mDocId;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mDocId);
        super.serializeData(out);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mDocId = in.readInt();
        super.deserializeData(in);
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        OperationContext octxt = this.getOperationContext();
        try {
            mbox.addDocumentRevision(octxt, this.mDocId, this.getAdditionalDataStream(), this.getAuthor(), this.getFilename());
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.ALREADY_EXISTS") {
                mLog.info("Document revision " + this.getMessageId() + " is already in mailbox " + mboxId);
                return;
            }
            throw e;
        }
    }
}

