/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.logger;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.redolog.CommitId;
import com.zimbra.cs.redolog.RedoCommitCallback;
import com.zimbra.cs.redolog.RedoConfig;
import com.zimbra.cs.redolog.RedoLogManager;
import com.zimbra.cs.redolog.RolloverManager;
import com.zimbra.cs.redolog.logger.FileHeader;
import com.zimbra.cs.redolog.logger.LogWriter;
import com.zimbra.cs.redolog.op.CommitTxn;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.util.Zimbra;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FileLogWriter
implements LogWriter {
    private static String sServerId;
    protected RedoLogManager mRedoLogMgr;
    private final Object mLock = new Object();
    private final Object mFsyncCond = new Object();
    private FileHeader mHeader;
    private long mFirstOpTstamp;
    private long mLastOpTstamp;
    private long mCreateTime;
    private File mFile;
    private RandomAccessFile mRAF;
    private long mFileSize;
    private long mLastLogTime;
    private long mFsyncIntervalMS;
    private boolean mFsyncDisabled;
    private FsyncThread mFsyncer;
    private int mLogSeq;
    private int mFsyncSeq;
    private int mLogCount;
    private int mFsyncCount;
    private CommitNotifyQueue mCommitNotifyQueue;
    private long mLastOpMboxId;
    private boolean mNoStat;

    public FileLogWriter(RedoLogManager redoLogMgr, File logfile, long fsyncIntervalMS) {
        this.mRedoLogMgr = redoLogMgr;
        this.mHeader = new FileHeader(sServerId);
        this.mFile = logfile;
        this.mFileSize = this.mFile.length();
        this.mLastLogTime = this.mFile.lastModified();
        this.mFsyncIntervalMS = fsyncIntervalMS;
        this.mFsyncDisabled = DebugConfig.disableRedoLogFsync;
        this.mLogCount = 0;
        this.mFsyncCount = 0;
        this.mCommitNotifyQueue = new CommitNotifyQueue(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSequence() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHeader.getSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFileSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCreateTime() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCreateTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastLogTime() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastLogTime;
        }
    }

    public boolean isEmpty() throws IOException {
        return this.getSize() <= 512L;
    }

    public boolean exists() {
        return this.mFile.exists();
    }

    public String getAbsolutePath() {
        return this.mFile.getAbsolutePath();
    }

    public boolean renameTo(File dest) {
        return this.mFile.renameTo(dest);
    }

    public boolean delete() {
        return this.mFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRAF != null) {
                return;
            }
            this.mRAF = new RandomAccessFile(this.mFile, "rw");
            if (this.mRAF.length() >= 512L) {
                this.mHeader.read(this.mRAF);
                this.mCreateTime = this.mHeader.getCreateTime();
                if (this.mCreateTime == 0L) {
                    this.mCreateTime = System.currentTimeMillis();
                    this.mHeader.setCreateTime(this.mCreateTime);
                }
                this.mFirstOpTstamp = this.mHeader.getFirstOpTstamp();
                this.mLastOpTstamp = this.mHeader.getLastOpTstamp();
            } else {
                this.mCreateTime = System.currentTimeMillis();
                this.mHeader.setCreateTime(this.mCreateTime);
                this.mHeader.setSequence(this.mRedoLogMgr.getCurrentLogSequence());
            }
            this.mHeader.setOpen(true);
            this.mHeader.write(this.mRAF);
            long len = this.mRAF.length();
            this.mRAF.seek(len);
            this.mFileSize = len;
            this.mFsyncSeq = 0;
            this.mLogSeq = 0;
        }
        if (this.mFsyncIntervalMS > 0L) {
            this.startFsyncThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        this.stopFsyncThread();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRAF != null) {
                if (this.mLastOpTstamp != 0L) {
                    this.mHeader.setLastOpTstamp(this.mLastOpTstamp);
                }
            } else {
                return;
            }
            this.mHeader.setOpen(false);
            this.mHeader.setFileSize(this.mRAF.length());
            this.mHeader.write(this.mRAF);
            this.mRAF.getChannel().force(true);
            this.mRAF.close();
            this.mRAF = null;
        }
        if (!this.mNoStat && this.mLogCount > 0 && ZimbraLog.redolog.isDebugEnabled()) {
            ZimbraLog.redolog.debug("Logged: " + this.mLogCount + " items, " + this.mFsyncCount + " fsyncs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(RedoableOp op, InputStream data, boolean synchronous) throws IOException {
        int seq;
        boolean sameMboxAsLastOp = false;
        Object object = this.mLock;
        synchronized (object) {
            CommitTxn cmt;
            RedoCommitCallback cb;
            int numRead;
            if (this.mRAF == null) {
                throw new IOException("Redolog file closed");
            }
            long tstamp = op.getTimestamp();
            this.mLastOpTstamp = Math.max(tstamp, this.mLastOpTstamp);
            if (this.mFirstOpTstamp == 0L) {
                this.mFirstOpTstamp = tstamp;
                this.mHeader.setFirstOpTstamp(this.mFirstOpTstamp);
                this.mHeader.setLastOpTstamp(this.mLastOpTstamp);
                long pos = this.mRAF.getFilePointer();
                this.mHeader.write(this.mRAF);
                this.mRAF.seek(pos);
            }
            ++this.mLogSeq;
            ++this.mLogCount;
            seq = this.mLogSeq;
            byte[] buf = new byte[1024];
            while ((numRead = data.read(buf)) >= 0) {
                this.mRAF.write(buf, 0, numRead);
                this.mFileSize += (long)numRead;
            }
            data.close();
            if (op instanceof CommitTxn && (cb = (cmt = (CommitTxn)op).getCallback()) != null) {
                long redoSeq = this.mRedoLogMgr.getRolloverManager().getCurrentSequence();
                CommitId cid = new CommitId(redoSeq, (CommitTxn)op);
                Notif notif = new Notif(cb, cid);
                this.mCommitNotifyQueue.push(notif);
            }
            this.mLastLogTime = System.currentTimeMillis();
            sameMboxAsLastOp = this.mLastOpMboxId == op.getMailboxId();
            this.mLastOpMboxId = op.getMailboxId();
        }
        if (!synchronous) {
            return;
        }
        if (this.mFsyncIntervalMS > 0L) {
            if (!sameMboxAsLastOp) {
                try {
                    object = this.mFsyncCond;
                    synchronized (object) {
                        this.mFsyncCond.wait(10000L);
                    }
                }
                catch (InterruptedException e) {
                    ZimbraLog.redolog.info("Thread interrupted during fsync");
                }
                object = this.mLock;
                synchronized (object) {
                    if (seq > this.mFsyncSeq) {
                        this.fsync();
                    }
                }
            }
            this.fsync();
        } else {
            this.fsync();
        }
    }

    public void flush() throws IOException {
        this.fsync();
    }

    public void noStat(boolean b) {
        this.mNoStat = b;
    }

    public synchronized File rollover(LinkedHashMap activeOps) throws IOException {
        RolloverManager romgr = this.mRedoLogMgr.getRolloverManager();
        long lastSeq = this.getSequence();
        this.noStat(true);
        this.close();
        romgr.incrementSequence();
        String currentPath = this.mFile.getAbsolutePath();
        File tempLogfile = new File(this.mFile.getParentFile(), romgr.getTempFilename(lastSeq + 1L));
        FileLogWriter tempLogger = new FileLogWriter(this.mRedoLogMgr, tempLogfile, 0L);
        tempLogger.open();
        tempLogger.noStat(true);
        Set opsSet = activeOps.entrySet();
        for (Map.Entry entry : opsSet) {
            RedoableOp op = (RedoableOp)entry.getValue();
            tempLogger.log(op, op.getInputStream(), false);
        }
        tempLogger.close();
        File rolloverFile = romgr.getRolloverFile(lastSeq);
        if (RedoConfig.redoLogDeleteOnRollover()) {
            if (!this.mFile.delete()) {
                throw new IOException("Unable to delete current redo log " + this.mFile.getAbsolutePath());
            }
        } else {
            File destDir = rolloverFile.getParentFile();
            if (destDir != null && !destDir.exists()) {
                destDir.mkdirs();
            }
            if (!this.mFile.renameTo(rolloverFile)) {
                throw new IOException("Unable to rename current redo log to " + rolloverFile.getAbsolutePath());
            }
        }
        String tempPath = tempLogfile.getAbsolutePath();
        this.mFile = new File(currentPath);
        if (!tempLogfile.renameTo(this.mFile)) {
            throw new IOException("Unable to rename " + tempPath + " to " + currentPath);
        }
        this.open();
        this.noStat(false);
        return rolloverFile;
    }

    public synchronized void enableFsync() throws IOException {
        this.startFsyncThread();
        this.fsync();
    }

    public synchronized void disableFsync() throws IOException {
        this.fsync();
        this.stopFsyncThread();
    }

    private synchronized void startFsyncThread() {
        if (this.mFsyncer == null && this.mFsyncIntervalMS > 0L) {
            this.mFsyncer = new FsyncThread(this.mFsyncIntervalMS);
            this.mFsyncer.start();
        }
    }

    private synchronized void stopFsyncThread() {
        if (this.mFsyncer != null) {
            this.mFsyncer.stopThread();
            this.mFsyncer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsync() throws IOException {
        boolean fsyncNeeded = false;
        int seq = 0;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFsyncSeq < this.mLogSeq) {
                if (this.mRAF == null) {
                    throw new IOException("Redolog file closed");
                }
                fsyncNeeded = true;
                seq = this.mLogSeq;
                if (!this.mFsyncDisabled) {
                    ++this.mFsyncCount;
                }
            }
        }
        if (fsyncNeeded) {
            if (!this.mFsyncDisabled) {
                object = this.mLock;
                synchronized (object) {
                    if (this.mRAF == null) {
                        throw new IOException("Redolog file closed");
                    }
                    this.mRAF.getChannel().force(false);
                    this.mCommitNotifyQueue.flush(false);
                }
            }
            object = this.mLock;
            synchronized (object) {
                this.mFsyncSeq = seq;
            }
            if (this.mFsyncIntervalMS > 0L) {
                object = this.mFsyncCond;
                synchronized (object) {
                    this.mFsyncCond.notifyAll();
                }
            }
        }
    }

    static {
        try {
            sServerId = Provisioning.getInstance().getLocalServer().getId();
        }
        catch (ServiceException e) {
            ZimbraLog.redolog.error((Object)"Unable to get local server ID", e);
            sServerId = "unknown";
        }
    }

    private class CommitNotifyQueue {
        private Notif[] mQueue = new Notif[100];
        private int mHead;
        private int mTail;
        private boolean mFull;

        public CommitNotifyQueue(int size) {
            this.mQueue = new Notif[size];
            this.mTail = 0;
            this.mHead = 0;
            this.mFull = false;
        }

        public synchronized void push(Notif notif) throws IOException {
            if (notif != null) {
                if (this.mFull) {
                    this.flush(true);
                }
                assert (!this.mFull);
                this.mQueue[this.mTail] = notif;
                ++this.mTail;
                this.mTail %= this.mQueue.length;
                this.mFull = this.mTail == this.mHead;
            }
        }

        private synchronized Notif pop() {
            if (this.mHead == this.mTail && !this.mFull) {
                return null;
            }
            Notif n = this.mQueue[this.mHead];
            this.mQueue[this.mHead] = null;
            ++this.mHead;
            this.mHead %= this.mQueue.length;
            this.mFull = false;
            return n;
        }

        public synchronized void flush(boolean fsync) throws IOException {
            Notif notif;
            if (fsync) {
                FileLogWriter.this.fsync();
            }
            while ((notif = this.pop()) != null) {
                RedoCommitCallback cb = notif.getCallback();
                assert (cb != null);
                try {
                    cb.callback(notif.getCommitId());
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                }
                catch (Throwable t) {
                    ZimbraLog.misc.error((Object)"Error while making commit callback", t);
                }
            }
        }
    }

    private static class Notif {
        private RedoCommitCallback mCallback;
        private CommitId mCommitId;

        public Notif(RedoCommitCallback callback, CommitId cid) {
            this.mCallback = callback;
            this.mCommitId = cid;
        }

        public RedoCommitCallback getCallback() {
            return this.mCallback;
        }

        public CommitId getCommitId() {
            return this.mCommitId;
        }
    }

    private class FsyncThread
    extends Thread {
        private long mSleepMS;
        private Object mFsyncLock;
        private boolean mRunning;
        private static final long MIN_SLEEP_MILLIS = 1L;
        private static final long MAX_SLEEP_MILLIS = 1000L;

        public FsyncThread(long fsyncIntervalMS) {
            super("FileLogWriter.FsyncThread");
            if (fsyncIntervalMS < 1L) {
                ZimbraLog.redolog.warn("Invalid fsync thread sleep interval %dms; using %dms instead", fsyncIntervalMS, 1L);
                this.mSleepMS = 1L;
            } else if (fsyncIntervalMS > 1000L) {
                ZimbraLog.redolog.warn("Fsync thread sleep interval %ms is too long; using %dms instead", fsyncIntervalMS, 1000L);
                this.mSleepMS = 1000L;
            } else {
                this.mSleepMS = fsyncIntervalMS;
            }
            this.mFsyncLock = new Object();
            this.mRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running = true;
            while (running) {
                try {
                    Thread.sleep(this.mSleepMS);
                }
                catch (InterruptedException e) {
                    ZimbraLog.redolog.warn((Object)"Sync thread interrupted", e);
                }
                try {
                    FileLogWriter.this.fsync();
                }
                catch (IOException e) {
                    String message = "Error while fsyncing " + FileLogWriter.this.mFile.getAbsolutePath() + "; Aborting.";
                    Zimbra.halt(message, e);
                }
                Object object = this.mFsyncLock;
                synchronized (object) {
                    running = this.mRunning;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            Object object = this.mFsyncLock;
            synchronized (object) {
                this.mRunning = false;
            }
            try {
                this.join();
            }
            catch (InterruptedException e) {
                ZimbraLog.redolog.warn((Object)"InterruptedException while stopping FsyncThread", e);
            }
        }
    }
}

