/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.logger;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.logger.FileHeader;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileLogReader {
    private FileHeader mHeader = new FileHeader();
    private boolean mHeaderRead = false;
    private File mFile;
    private RandomAccessFile mRAF;
    private RedoLogInput mIN;
    private boolean mReadOnly;
    private long mFileSizeAtOpen;
    private long mLastOpStartOffset;

    public FileLogReader(File logfile) {
        this(logfile, false);
    }

    public FileLogReader(File logfile, boolean writable) {
        this.mFile = logfile;
        this.mReadOnly = !writable;
    }

    public synchronized void open() throws IOException {
        this.mRAF = new RandomAccessFile(this.mFile, this.mReadOnly ? "r" : "rw");
        this.mIN = new RedoLogInput(this.mRAF, this.mFile.getPath());
        this.mHeader.read(this.mRAF);
        this.mHeaderRead = true;
        this.mFileSizeAtOpen = this.mRAF.length();
    }

    public synchronized void close() throws IOException {
        this.mRAF.close();
    }

    public synchronized FileHeader getHeader() throws IOException {
        if (this.mHeaderRead) {
            return this.mHeader;
        }
        this.open();
        this.close();
        return this.mHeader;
    }

    public synchronized RedoableOp getNextOp() throws IOException {
        long pos = this.mRAF.getFilePointer();
        if (pos == this.mFileSizeAtOpen) {
            return null;
        }
        boolean first = true;
        long currPos = pos;
        while (true) {
            String msg;
            try {
                RedoableOp op = RedoableOp.deserializeOp(this.mIN);
                this.mLastOpStartOffset = currPos;
                if (!first) {
                    msg = String.format("Skipped bad bytes in redolog %s; resuming at offset 0x%08x after skipping %d bytes", this.mFile.getAbsolutePath(), currPos, currPos - pos);
                    ZimbraLog.redolog.warn(msg);
                }
                return op;
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    throw e;
                }
                if (first) {
                    msg = String.format("Error while parsing redolog %s, offset=0x%08x; bad bytes will be skipped", this.mFile.getAbsolutePath(), pos);
                    ZimbraLog.redolog.warn((Object)msg, e);
                }
                first = false;
                this.mRAF.seek(currPos + 1L);
                if (this.searchInRAF("ZMREDO".getBytes())) {
                    currPos = this.mRAF.getFilePointer();
                    continue;
                }
                String msg2 = String.format("Found %d junk bytes from offset 0x%08x to end of file, in redolog %s", this.mFileSizeAtOpen - pos, pos, this.mFile.getAbsolutePath());
                throw new IOException(msg2);
            }
            break;
        }
    }

    public synchronized long getSize() throws IOException {
        return this.mRAF.length();
    }

    public synchronized long position() throws IOException {
        return this.mRAF.getFilePointer();
    }

    public synchronized long getLastOpStartOffset() throws IOException {
        return this.mLastOpStartOffset;
    }

    public synchronized void truncate(long size) throws IOException {
        if (size < this.mRAF.length()) {
            this.mRAF.setLength(size);
            FileHeader hdr = this.getHeader();
            hdr.setFileSize(size);
            hdr.write(this.mRAF);
            this.mRAF.seek(size);
        }
    }

    private boolean searchInRAF(byte[] pattern) throws IOException {
        int bytesRead;
        int viewSize = 4096;
        if (pattern.length > viewSize) {
            return false;
        }
        byte[] view = new byte[viewSize * 2];
        long rafPos = this.mRAF.getFilePointer();
        long viewBaseOffset = rafPos - rafPos % (long)viewSize;
        this.mRAF.seek(viewBaseOffset);
        int startOffset = (int)(rafPos - viewBaseOffset);
        boolean atFileEnd = false;
        while (!atFileEnd && (bytesRead = this.mRAF.read(view, 0, view.length)) != -1 && bytesRead >= pattern.length) {
            int endOffset;
            int matchAt;
            boolean bl = atFileEnd = viewBaseOffset + (long)bytesRead >= this.mFileSizeAtOpen;
            if (atFileEnd) {
                bytesRead = (int)(this.mFileSizeAtOpen - viewBaseOffset);
            }
            if ((matchAt = FileLogReader.searchByteArray(view, startOffset, endOffset = Math.min(view.length, bytesRead), pattern)) != -1) {
                this.mRAF.seek(viewBaseOffset + (long)matchAt);
                return true;
            }
            this.mRAF.seek(viewBaseOffset += (long)viewSize);
            startOffset = 0;
        }
        this.mRAF.seek(rafPos);
        return false;
    }

    private static int searchByteArray(byte[] searchIn, int startOffset, int endOffset, byte[] pattern) {
        int len = pattern.length;
        endOffset = Math.min(endOffset, searchIn.length);
        byte firstByte = pattern[0];
        int lastIndex = endOffset - len;
        for (int i = startOffset; i < lastIndex; ++i) {
            while (searchIn[i] != firstByte && i < lastIndex) {
                ++i;
            }
            if (i >= lastIndex) break;
            boolean matches = true;
            for (int j = 1; j < len; ++j) {
                if (searchIn[i + j] == pattern[j]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return i;
        }
        return -1;
    }
}

