/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.logger;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.Version;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class FileHeader {
    public static final int HEADER_LEN = 512;
    private static final int SERVER_ID_FIELD_LEN = 127;
    private static final byte[] MAGIC = "ZM_REDO".getBytes();
    private byte mOpen = 0;
    private long mFileSize = 0L;
    private long mSeq = 0L;
    private String mServerId;
    private long mFirstOpTstamp;
    private long mLastOpTstamp;
    private long mCreateTime;
    private Version mVersion;
    private static String DATE_FORMAT = "EEE, yyyy/MM/dd HH:mm:ss.SSS z";

    FileHeader() {
        this("unknown");
    }

    FileHeader(String serverId) {
        this.mServerId = serverId;
        this.mFirstOpTstamp = 0L;
        this.mLastOpTstamp = 0L;
        this.mCreateTime = 0L;
        this.mVersion = Version.latest();
    }

    void write(RandomAccessFile raf) throws IOException {
        if (!this.mVersion.isLatest()) {
            this.mVersion = Version.latest();
        }
        byte[] buf = this.serialize();
        raf.seek(0L);
        raf.write(buf);
        raf.getFD().sync();
    }

    void read(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        byte[] header = new byte[512];
        int bytesRead = raf.read(header, 0, 512);
        if (bytesRead < 512) {
            throw new IOException("Redolog is smaller than header length of 512 bytes");
        }
        this.deserialize(header);
    }

    void setOpen(boolean b) {
        this.mOpen = b ? (byte)1 : 0;
    }

    void setFileSize(long s) {
        this.mFileSize = s;
    }

    void setSequence(long seq) {
        this.mSeq = seq;
    }

    void setFirstOpTstamp(long t) {
        this.mFirstOpTstamp = t;
    }

    void setLastOpTstamp(long t) {
        this.mLastOpTstamp = t;
    }

    void setCreateTime(long t) {
        this.mCreateTime = t;
    }

    public boolean getOpen() {
        return this.mOpen != 0;
    }

    public long getFileSize() {
        return this.mFileSize;
    }

    public long getSequence() {
        return this.mSeq;
    }

    public String getServerId() {
        return this.mServerId;
    }

    public long getFirstOpTstamp() {
        return this.mFirstOpTstamp;
    }

    public long getLastOpTstamp() {
        return this.mLastOpTstamp;
    }

    public long getCreateTime() {
        return this.mCreateTime;
    }

    private byte[] getStringBytes(String str, String charset, int maxlen) {
        byte[] buf;
        String substr = str;
        int len = substr.length();
        while (len > 0) {
            buf = null;
            try {
                buf = substr.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                break;
            }
            if (buf.length <= maxlen) {
                return buf;
            }
            substr = substr.substring(0, --len);
        }
        buf = new byte[]{};
        return buf;
    }

    private byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        RedoLogOutput out = new RedoLogOutput(baos);
        out.write(MAGIC);
        out.writeByte(this.mOpen);
        out.writeLong(this.mFileSize);
        out.writeLong(this.mSeq);
        byte[] serverIdBuf = this.getStringBytes(this.mServerId, "UTF-8", 127);
        out.writeByte((byte)serverIdBuf.length);
        out.write(serverIdBuf);
        if (serverIdBuf.length < 127) {
            byte[] padding = new byte[127 - serverIdBuf.length];
            Arrays.fill(padding, (byte)0);
            out.write(padding);
        }
        out.writeLong(this.mFirstOpTstamp);
        out.writeLong(this.mLastOpTstamp);
        this.mVersion.serialize(out);
        out.writeLong(this.mCreateTime);
        int currentLen = baos.size();
        if (currentLen < 512) {
            int paddingLen = 512 - currentLen;
            byte[] b = new byte[paddingLen];
            Arrays.fill(b, (byte)0);
            out.write(b);
        }
        byte[] headerBuf = baos.toByteArray();
        baos.close();
        if (headerBuf.length != 512) {
            throw new IOException("Wrong redolog header length of " + headerBuf.length + "; should be " + 512);
        }
        return headerBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize(byte[] headerBuf) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBuf);
        RedoLogInput in = new RedoLogInput(bais);
        try {
            byte[] magic = new byte[MAGIC.length];
            in.readFully(magic, 0, MAGIC.length);
            if (!Arrays.equals(magic, MAGIC)) {
                throw new IOException("Missing magic bytes in redolog header");
            }
            this.mOpen = in.readByte();
            this.mFileSize = in.readLong();
            this.mSeq = in.readLong();
            byte serverIdLen = in.readByte();
            if (serverIdLen > 127) {
                throw new IOException("ServerId too long (" + serverIdLen + " bytes) in redolog header");
            }
            byte[] serverIdBuf = new byte[127];
            in.readFully(serverIdBuf, 0, 127);
            this.mServerId = new String(serverIdBuf, 0, (int)serverIdLen, "UTF-8");
            this.mFirstOpTstamp = in.readLong();
            this.mLastOpTstamp = in.readLong();
            this.mVersion.deserialize(in);
            if (this.mVersion.tooHigh()) {
                throw new IOException("Redo log version " + this.mVersion + " is higher than the highest known version " + Version.latest());
            }
            if (!this.mVersion.atLeast(1, 0)) {
                this.mVersion = new Version(1, 0);
            }
            this.mCreateTime = in.readLong();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bais.close();
            throw throwable;
        }
        bais.close();
    }

    public String toString() {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
        StringBuilder sb = new StringBuilder(100);
        sb.append("sequence: ").append(this.mSeq).append("\n");
        sb.append("open:     ").append(this.mOpen).append("\n");
        sb.append("filesize: ").append(this.mFileSize).append("\n");
        sb.append("serverId: ").append(this.mServerId).append("\n");
        sb.append("created:  ");
        if (this.mCreateTime != 0L) {
            sb.append(fmt.format(new Date(this.mCreateTime))).append(" (").append(this.mCreateTime).append(")");
        }
        sb.append("\n");
        sb.append("first op: ");
        if (this.mFirstOpTstamp != 0L) {
            sb.append(fmt.format(new Date(this.mFirstOpTstamp))).append(" (").append(this.mFirstOpTstamp).append(")");
        }
        sb.append("\n");
        sb.append("last op:  ");
        if (this.mLastOpTstamp != 0L) {
            sb.append(fmt.format(new Date(this.mLastOpTstamp))).append(" (").append(this.mLastOpTstamp).append(")");
            if (this.mOpen != 0) {
                sb.append(" (not up to date)");
            }
        }
        sb.append("\n");
        sb.append("version:  ").append(this.mVersion).append("\n");
        return sb.toString();
    }
}

