/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import java.io.IOException;

public class Version {
    private static final short CURRENT_MAJOR = 1;
    private static final short CURRENT_MINOR = 28;
    private short mMajorVer;
    private short mMinorVer;

    public static Version latest() {
        return new Version(1, 28);
    }

    public Version() {
        this.mMajorVer = 1;
        this.mMinorVer = (short)28;
    }

    public Version(int major, int minor) {
        this.mMajorVer = (short)major;
        this.mMinorVer = (short)minor;
    }

    public Version(Version b) {
        this(b.mMajorVer, b.mMinorVer);
    }

    public boolean atLeast(int major, int minor) {
        return this.mMajorVer > major || this.mMajorVer == major && this.mMinorVer >= minor;
    }

    public boolean atLeast(Version b) {
        return this.atLeast(b.mMajorVer, b.mMinorVer);
    }

    public boolean isLatest() {
        return this.mMajorVer == 1 && this.mMinorVer == 28;
    }

    public boolean tooHigh() {
        return this.mMajorVer > 1 || this.mMajorVer == 1 && this.mMinorVer > 28;
    }

    public String toString() {
        return Integer.toString(this.mMajorVer) + "." + Integer.toString(this.mMinorVer);
    }

    public void serialize(RedoLogOutput out) throws IOException {
        out.writeShort(this.mMajorVer);
        out.writeShort(this.mMinorVer);
    }

    public void deserialize(RedoLogInput in) throws IOException {
        this.mMajorVer = in.readShort();
        this.mMinorVer = in.readShort();
        if (this.mMajorVer < 0 || this.mMinorVer < 0) {
            throw new IOException("Negative version number: major=" + this.mMajorVer + ", minor=" + this.mMinorVer);
        }
    }

    public boolean equals(Object obj) {
        Version b = (Version)obj;
        return b.mMajorVer == this.mMajorVer && b.mMinorVer == this.mMinorVer;
    }
}

