/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import java.io.IOException;

public class TransactionId {
    private int mTime;
    private int mCounter;

    public TransactionId(int time, int counter) {
        this.mTime = time;
        this.mCounter = counter;
    }

    public TransactionId() {
        this.mTime = 0;
        this.mCounter = 0;
    }

    public int compareTo(TransactionId b) {
        if (this.mTime == b.mTime) {
            if (this.mCounter < b.mCounter) {
                return -1;
            }
            if (this.mCounter > b.mCounter) {
                return 1;
            }
            return 0;
        }
        if (this.mTime < b.mTime) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return Integer.toString(this.mTime) + "." + Integer.toString(this.mCounter);
    }

    public void serialize(RedoLogOutput out) throws IOException {
        out.writeInt(this.mTime);
        out.writeInt(this.mCounter);
    }

    public void deserialize(RedoLogInput in) throws IOException {
        this.mTime = in.readInt();
        this.mCounter = in.readInt();
    }

    public boolean equals(Object obj) {
        TransactionId b = (TransactionId)obj;
        return b.mTime == this.mTime && b.mCounter == this.mCounter;
    }

    public int hashCode() {
        return this.mCounter;
    }

    public int getTime() {
        return this.mTime;
    }

    public int getCounter() {
        return this.mCounter;
    }

    public String encodeToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mTime).append('-').append(this.mCounter);
        return sb.toString();
    }

    public static TransactionId decodeFromString(String str) throws ServiceException {
        String[] fields;
        NumberFormatException cause = null;
        if (str != null && (fields = str.split("-", 2)) != null && fields.length == 2) {
            try {
                int time = Integer.parseInt(fields[0]);
                int counter = Integer.parseInt(fields[1]);
                return new TransactionId(time, counter);
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        throw ServiceException.PARSE_ERROR("Invalid TransactionId " + str, cause);
    }
}

