/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.redolog.RedoConfig;
import com.zimbra.cs.redolog.RedoLogManager;
import com.zimbra.cs.redolog.TransactionId;
import com.zimbra.cs.redolog.logger.FileLogReader;
import com.zimbra.cs.redolog.logger.LogWriter;
import com.zimbra.cs.redolog.op.AbortTxn;
import com.zimbra.cs.redolog.op.Checkpoint;
import com.zimbra.cs.redolog.op.CommitTxn;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.StoreIncomingBlob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedoPlayer {
    private static final int INITIAL_MAP_SIZE = 1000;
    private final Object mOpsMapGuard = new Object();
    private LinkedHashMap<TransactionId, RedoableOp> mOpsMap;
    private boolean mWritable;
    private boolean mUnloggedReplay;
    private boolean mIgnoreReplayErrors;
    private boolean mSkipDeleteOps;
    private boolean mHasOrphanOps = false;
    private Map<TransactionId, RedoableOp> mOrphanOps = new HashMap<TransactionId, RedoableOp>();

    public RedoPlayer(boolean writable) {
        this(writable, false, false, false);
    }

    public RedoPlayer(boolean writable, boolean unloggedReplay, boolean ignoreReplayErrors, boolean skipDeleteOps) {
        this.mOpsMap = new LinkedHashMap(1000);
        this.mWritable = writable;
        this.mUnloggedReplay = unloggedReplay;
        this.mIgnoreReplayErrors = ignoreReplayErrors;
        this.mSkipDeleteOps = skipDeleteOps;
    }

    public void shutdown() {
        this.mOpsMap.clear();
    }

    public void scanLog(File logfile, boolean redoCommitted, Map<Long, Long> mboxIDsMap, long startTime, long endTime) throws IOException, ServiceException {
        this.scanLog(logfile, redoCommitted, mboxIDsMap, startTime, endTime, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanLog(File logfile, boolean redoCommitted, Map<Long, Long> mboxIDsMap, long startTime, long endTime, long ignoreCommitsAtOrAfter) throws IOException, ServiceException {
        FileLogReader logReader = new FileLogReader(logfile, this.mWritable);
        logReader.open();
        long lastPosition = 0L;
        try {
            try {
                RedoableOp op = null;
                while ((op = logReader.getNextOp()) != null) {
                    lastPosition = logReader.position();
                    if (ZimbraLog.redolog.isDebugEnabled()) {
                        ZimbraLog.redolog.debug("Read: " + op);
                    }
                    this.processOp(op, redoCommitted, mboxIDsMap, startTime, endTime, ignoreCommitsAtOrAfter);
                }
                Object var20_11 = null;
            }
            catch (IOException e) {
                ZimbraLog.redolog.warn((Object)"IOException while reading redolog file", e);
                long size = logReader.getSize();
                if (lastPosition < size) {
                    long diff = size - lastPosition;
                    String msg = "There were " + diff + " bytes of junk data at the end of " + logfile.getAbsolutePath() + ".";
                    if (this.mWritable) {
                        ZimbraLog.redolog.warn(msg + "  File will be truncated to " + lastPosition + " bytes.");
                        logReader.truncate(lastPosition);
                    } else {
                        ZimbraLog.redolog.warn(msg);
                    }
                }
                Object var20_12 = null;
                logReader.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var20_13 = null;
            logReader.close();
            throw throwable;
        }
        logReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processOp(RedoableOp op, boolean redoCommitted, Map<Long, Long> mboxIDsMap, long startTime, long endTime, long ignoreCommitsAtOrAfter) throws ServiceException {
        if (op.isStartMarker()) {
            Object object = this.mOpsMapGuard;
            synchronized (object) {
                RedoableOp x;
                this.mOpsMap.put(op.getTransactionId(), op);
                if (this.mHasOrphanOps && (x = this.mOrphanOps.remove(op.getTransactionId())) != null) {
                    ZimbraLog.redolog.error("Detected out-of-order insertion of change record for orphans commit/abort: change=" + op + ", orphan=" + x);
                }
            }
        }
        if (op instanceof Checkpoint) {
            Checkpoint ckpt = (Checkpoint)op;
            Set txns = ckpt.getActiveTxns();
            if (txns.size() > 0) {
                Object object = this.mOpsMapGuard;
                synchronized (object) {
                    if (this.mOpsMap.size() != txns.size() && ZimbraLog.redolog.isDebugEnabled()) {
                        StringBuffer sb1 = new StringBuffer("Current Uncommitted Ops: ");
                        StringBuffer sb2 = new StringBuffer("Checkpoint Uncommitted Ops: ");
                        int i = 0;
                        for (TransactionId id : this.mOpsMap.keySet()) {
                            if (i > 0) {
                                sb1.append(", ");
                            }
                            sb1.append(id);
                            ++i;
                        }
                        i = 0;
                        for (TransactionId id : txns) {
                            if (i > 0) {
                                sb2.append(", ");
                            }
                            sb2.append(id);
                            ++i;
                        }
                        ZimbraLog.redolog.info("Checkpoint discrepancy: # current uncommitted ops = " + this.mOpsMap.size() + ", # checkpoint uncommitted ops = " + txns.size() + "\nMAP DUMP:\n" + sb1.toString() + "\n" + sb2.toString());
                    }
                }
            } else {
                Object object = this.mOpsMapGuard;
                synchronized (object) {
                    if (this.mOpsMap.size() != 0 && ZimbraLog.redolog.isDebugEnabled()) {
                        StringBuffer sb1 = new StringBuffer("Current Uncommitted Ops: ");
                        int i = 0;
                        for (TransactionId id : this.mOpsMap.keySet()) {
                            if (i > 0) {
                                sb1.append(", ");
                            }
                            sb1.append(id);
                            ++i;
                        }
                        ZimbraLog.redolog.info("Checkpoint discrepancy: # current uncommitted ops = " + this.mOpsMap.size() + " instead of 0\nMAP DUMP:\n" + sb1.toString());
                    }
                }
            }
        } else if (op.isEndMarker()) {
            boolean isCommitOp = op instanceof CommitTxn;
            long opTstamp = op.getTimestamp();
            if (!isCommitOp || opTstamp < ignoreCommitsAtOrAfter) {
                RedoableOp prepareOp;
                Object i = this.mOpsMapGuard;
                synchronized (i) {
                    prepareOp = (RedoableOp)this.mOpsMap.remove(op.getTransactionId());
                    if (prepareOp == null) {
                        this.mHasOrphanOps = true;
                        ZimbraLog.redolog.error("Commit/abort record encountered before corresponding change record (" + op + ")");
                        TransactionId tid = op.getTransactionId();
                        RedoableOp x = this.mOrphanOps.get(tid);
                        if (x != null) {
                            ZimbraLog.redolog.error("Op [" + op + "] is already in orphans map: value=" + x);
                        }
                        this.mOrphanOps.put(tid, op);
                    }
                }
                if (redoCommitted && prepareOp != null && isCommitOp && (startTime == -1L || prepareOp.getTimestamp() >= startTime) && opTstamp < endTime) {
                    boolean allowRedo = false;
                    if (mboxIDsMap == null) {
                        allowRedo = true;
                    } else {
                        long opMailboxId = prepareOp.getMailboxId();
                        if (prepareOp instanceof StoreIncomingBlob) {
                            assert (opMailboxId == -1L);
                            StoreIncomingBlob storeOp = (StoreIncomingBlob)prepareOp;
                            List<Long> list = storeOp.getMailboxIdList();
                            if (list != null) {
                                HashSet<Long> opMboxIds = new HashSet<Long>(list);
                                for (Map.Entry<Long, Long> entry : mboxIDsMap.entrySet()) {
                                    if (!opMboxIds.contains(entry.getKey())) continue;
                                    allowRedo = true;
                                    ArrayList<Long> newList = new ArrayList<Long>(mboxIDsMap.values());
                                    storeOp.setMailboxIdList(newList);
                                    break;
                                }
                            } else {
                                allowRedo = true;
                            }
                        } else if (opMailboxId == -1L) {
                            allowRedo = true;
                        } else {
                            for (Map.Entry<Long, Long> entry : mboxIDsMap.entrySet()) {
                                if (opMailboxId != (long)entry.getKey().intValue()) continue;
                                if (entry.getValue() != null) {
                                    prepareOp.setMailboxId(entry.getValue().intValue());
                                }
                                allowRedo = true;
                                break;
                            }
                        }
                    }
                    if (allowRedo) {
                        if (this.mSkipDeleteOps && prepareOp.isDeleteOp()) {
                            ZimbraLog.redolog.info("Skipping delete op: " + prepareOp.toString());
                        } else {
                            try {
                                if (ZimbraLog.redolog.isDebugEnabled()) {
                                    ZimbraLog.redolog.debug("Redoing: " + prepareOp.toString());
                                }
                                prepareOp.setUnloggedReplay(this.mUnloggedReplay);
                                this.playOp(prepareOp);
                            }
                            catch (Exception e) {
                                if (!this.ignoreReplayErrors()) {
                                    throw ServiceException.FAILURE("Error executing redoOp", e);
                                }
                                ZimbraLog.redolog.warn((Object)("Ignoring error during redo log replay: " + e.getMessage()), e);
                            }
                        }
                    }
                }
            }
        }
    }

    protected boolean ignoreReplayErrors() {
        return this.mIgnoreReplayErrors;
    }

    protected void playOp(RedoableOp op) throws Exception {
        op.redo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runCrashRecovery(RedoLogManager redoLogMgr, List<RedoableOp> postStartupRecoveryOps) throws Exception {
        int numOps;
        File redoLog = redoLogMgr.getLogFile();
        if (!redoLog.exists()) {
            return 0;
        }
        long lookBackTstamp = Long.MAX_VALUE;
        long lookBackDuration = RedoConfig.redoLogCrashRecoveryLookbackSec() * 1000L;
        if (lookBackDuration > 0L) {
            long logLastModTime = redoLog.lastModified();
            long logCreateTime = new FileLogReader(redoLog).getHeader().getCreateTime();
            long lastOpTstamp = Math.max(logLastModTime, logCreateTime);
            lookBackTstamp = lastOpTstamp - lookBackDuration;
        }
        LogWriter logWriter = redoLogMgr.getLogWriter();
        logWriter.close();
        this.scanLog(redoLog, false, null, Long.MIN_VALUE, Long.MAX_VALUE, lookBackTstamp);
        logWriter.open();
        Object object = this.mOpsMapGuard;
        synchronized (object) {
            numOps = this.mOpsMap.size();
        }
        if (numOps == 0) {
            ZimbraLog.redolog.info("No uncommitted transactions to redo");
            return 0;
        }
        object = this.mOpsMapGuard;
        synchronized (object) {
            Set<Map.Entry<TransactionId, RedoableOp>> entrySet = this.mOpsMap.entrySet();
            ZimbraLog.redolog.info("Redoing " + numOps + " uncommitted transactions");
            for (Map.Entry<TransactionId, RedoableOp> entry : entrySet) {
                AbortTxn abort;
                CommitTxn commit;
                Object var18_19;
                RedoableOp op = entry.getValue();
                if (op == null) continue;
                if (op.deferCrashRecovery()) {
                    ZimbraLog.redolog.info("Deferring crash recovery to after startup: " + op);
                    postStartupRecoveryOps.add(op);
                    continue;
                }
                if (ZimbraLog.redolog.isInfoEnabled()) {
                    ZimbraLog.redolog.info("REDOING: " + op);
                }
                boolean success = false;
                try {
                    try {
                        op.redo();
                        success = true;
                    }
                    catch (Exception e) {
                        ZimbraLog.redolog.error((Object)("Redo failed for [" + op + "]." + "  Backend state of affected item is indeterminate." + "  Marking operation as aborted and moving on."), e);
                        var18_19 = null;
                        if (success) {
                            commit = new CommitTxn(op);
                            redoLogMgr.logOnly(commit, true);
                            continue;
                        }
                        abort = new AbortTxn(op);
                        redoLogMgr.logOnly(abort, true);
                        continue;
                    }
                    var18_19 = null;
                    if (success) {
                        commit = new CommitTxn(op);
                        redoLogMgr.logOnly(commit, true);
                        continue;
                    }
                    abort = new AbortTxn(op);
                    redoLogMgr.logOnly(abort, true);
                }
                catch (Throwable throwable) {
                    var18_19 = null;
                    if (success) {
                        commit = new CommitTxn(op);
                        redoLogMgr.logOnly(commit, true);
                    } else {
                        abort = new AbortTxn(op);
                        redoLogMgr.logOnly(abort, true);
                    }
                    throw throwable;
                }
            }
            this.mOpsMap.clear();
        }
        MailboxIndex.flushAllWriters();
        return numOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedHashMap<TransactionId, RedoableOp> getCopyOfUncommittedOpsMap() {
        LinkedHashMap<TransactionId, RedoableOp> map;
        Object object = this.mOpsMapGuard;
        synchronized (object) {
            map = this.mOpsMap != null ? new LinkedHashMap<TransactionId, RedoableOp>(this.mOpsMap) : new LinkedHashMap();
        }
        return map;
    }
}

