/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.redolog.DefaultRedoLogProvider;
import com.zimbra.cs.redolog.RedoLogManager;
import com.zimbra.cs.util.Zimbra;

public abstract class RedoLogProvider {
    private static RedoLogProvider theInstance = null;
    protected RedoLogManager mRedoLogManager;

    public static RedoLogProvider getInstance() {
        return theInstance;
    }

    private static RedoLogProvider loadProvider() throws ServiceException {
        RedoLogProvider provider = null;
        Class providerClass = null;
        Server config = Provisioning.getInstance().getLocalServer();
        String className = config.getAttr("zimbraRedoLogProvider");
        try {
            if (className != null) {
                providerClass = Class.forName(className);
            } else {
                providerClass = DefaultRedoLogProvider.class;
                ZimbraLog.misc.debug("Redolog provider name not specified.  Using default " + providerClass.getName());
            }
            provider = (RedoLogProvider)providerClass.newInstance();
        }
        catch (OutOfMemoryError e) {
            Zimbra.halt("out of memory", e);
        }
        catch (Throwable e) {
            throw ServiceException.FAILURE("Unable to load redolog provider " + className, e);
        }
        return provider;
    }

    public abstract boolean isMaster();

    public abstract boolean isSlave();

    public abstract void startup() throws ServiceException;

    public abstract void shutdown() throws ServiceException;

    public abstract void initRedoLogManager();

    public RedoLogManager getRedoLogManager() {
        return this.mRedoLogManager;
    }

    static {
        try {
            theInstance = RedoLogProvider.loadProvider();
        }
        catch (ServiceException e) {
            Zimbra.halt("Unable to initialize redolog provider", e);
        }
    }
}

