/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.redolog.CommitId;
import com.zimbra.cs.redolog.RedoConfig;
import com.zimbra.cs.redolog.RedoPlayer;
import com.zimbra.cs.redolog.RolloverManager;
import com.zimbra.cs.redolog.TransactionId;
import com.zimbra.cs.redolog.logger.FileLogReader;
import com.zimbra.cs.redolog.logger.FileLogWriter;
import com.zimbra.cs.redolog.logger.LogWriter;
import com.zimbra.cs.redolog.op.AbortTxn;
import com.zimbra.cs.redolog.op.Checkpoint;
import com.zimbra.cs.redolog.op.CommitTxn;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.znative.IO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedoLogManager {
    private boolean mEnabled = false;
    private boolean mInCrashRecovery;
    private final Object mInCrashRecoveryGuard = new Object();
    private boolean mShuttingDown = false;
    private final Object mShuttingDownGuard = new Object();
    private boolean mInPostStartupCrashRecovery;
    private boolean mSupportsCrashRecovery;
    private boolean mRecoveryMode = false;
    private File mArchiveDir;
    private File mLogFile;
    private ReentrantWriterPreferenceReadWriteLock mRWLock;
    private LinkedHashMap<TransactionId, RedoableOp> mActiveOps;
    private long mLogRolloverMinAgeMillis;
    private long mLogRolloverSoftMaxBytes;
    private long mLogRolloverHardMaxBytes;
    private TxnIdGenerator mTxnIdGenerator;
    private RolloverManager mRolloverMgr;
    private long mInitialLogSize;
    private LogWriter mLogWriter;
    private Object mStatGuard;
    private long mElapsed;
    private int mCounter;

    public RedoLogManager(File redolog, File archdir, boolean supportsCrashRecovery) {
        this.mSupportsCrashRecovery = supportsCrashRecovery;
        this.mLogFile = redolog;
        this.mArchiveDir = archdir;
        this.mRWLock = new ReentrantWriterPreferenceReadWriteLock();
        this.mActiveOps = new LinkedHashMap(100);
        this.mTxnIdGenerator = new TxnIdGenerator();
        long minAge = RedoConfig.redoLogRolloverMinFileAge() * 60L * 1000L;
        long softMax = RedoConfig.redoLogRolloverFileSizeKB() * 1024L;
        long hardMax = RedoConfig.redoLogRolloverHardMaxFileSizeKB() * 1024L;
        this.setRolloverLimits(minAge, softMax, hardMax);
        this.mRolloverMgr = new RolloverManager(this, this.mLogFile);
        this.mLogWriter = null;
        this.mStatGuard = new Object();
        this.mElapsed = 0L;
        this.mCounter = 0;
    }

    protected LogWriter getLogWriter() {
        return this.mLogWriter;
    }

    public File getLogFile() {
        return this.mLogFile;
    }

    public File getArchiveDir() {
        return this.mArchiveDir;
    }

    public File getRolloverDestDir() {
        return this.mArchiveDir;
    }

    public LogWriter getCurrentLogWriter() {
        return this.mLogWriter;
    }

    public LogWriter createLogWriter(RedoLogManager redoMgr, File logfile, long fsyncIntervalMS) {
        return new FileLogWriter(redoMgr, logfile, fsyncIntervalMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInCrashRecovery(boolean b) {
        Object object = this.mInCrashRecoveryGuard;
        synchronized (object) {
            this.mInCrashRecovery = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInCrashRecovery() {
        Object object = this.mInCrashRecoveryGuard;
        synchronized (object) {
            return this.mInCrashRecovery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.mEnabled = true;
        try {
            File logdir = this.mLogFile.getParentFile();
            if (!logdir.exists() && !logdir.mkdirs()) {
                throw new IOException("Unable to create directory " + logdir.getAbsolutePath());
            }
            if (!this.mArchiveDir.exists() && !this.mArchiveDir.mkdirs()) {
                throw new IOException("Unable to create directory " + this.mArchiveDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.signalFatalError(e);
        }
        this.setInCrashRecovery(true);
        try {
            this.mRolloverMgr.crashRecovery();
        }
        catch (IOException e) {
            ZimbraLog.redolog.fatal("Exception during crash recovery");
            this.signalFatalError(e);
        }
        long fsyncInterval = RedoConfig.redoLogFsyncIntervalMS();
        this.mLogWriter = this.createLogWriter(this, this.mLogFile, fsyncInterval);
        ArrayList<RedoableOp> postStartupRecoveryOps = new ArrayList<RedoableOp>(100);
        int numRecoveredOps = 0;
        if (this.mSupportsCrashRecovery) {
            this.mRecoveryMode = true;
            ZimbraLog.redolog.info("Starting pre-startup crash recovery");
            try {
                this.mLogWriter.open();
                this.mRolloverMgr.initSequence(this.mLogWriter.getSequence());
                RedoPlayer redoPlayer = new RedoPlayer(true);
                try {
                    numRecoveredOps = redoPlayer.runCrashRecovery(this, postStartupRecoveryOps);
                    Object var7_10 = null;
                    redoPlayer.shutdown();
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    redoPlayer.shutdown();
                    throw throwable;
                }
                this.mLogWriter.close();
            }
            catch (Exception e) {
                ZimbraLog.redolog.fatal("Exception during crash recovery");
                this.signalFatalError(e);
            }
            ZimbraLog.redolog.info("Finished pre-startup crash recovery");
            this.mRecoveryMode = false;
        }
        this.setInCrashRecovery(false);
        try {
            this.mLogWriter.open();
            this.mRolloverMgr.initSequence(this.mLogWriter.getSequence());
            this.mInitialLogSize = this.mLogWriter.getSize();
        }
        catch (IOException e) {
            ZimbraLog.redolog.fatal("Unable to open redo log");
            this.signalFatalError(e);
        }
        if (numRecoveredOps > 0) {
            Object e;
            if (postStartupRecoveryOps.size() > 0) {
                e = this.mActiveOps;
                synchronized (e) {
                    for (RedoableOp op : postStartupRecoveryOps) {
                        assert (op.isStartMarker());
                        this.mActiveOps.put(op.getTransactionId(), op);
                    }
                }
            }
            this.forceRollover();
            if (postStartupRecoveryOps.size() > 0) {
                e = this.mShuttingDownGuard;
                synchronized (e) {
                    this.mInPostStartupCrashRecovery = true;
                }
                PostStartupCrashRecoveryThread psrThread = new PostStartupCrashRecoveryThread(postStartupRecoveryOps);
                psrThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.mEnabled) {
            return;
        }
        Object object = this.mShuttingDownGuard;
        synchronized (object) {
            this.mShuttingDown = true;
            if (this.mInPostStartupCrashRecovery) {
                try {
                    this.mShuttingDownGuard.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.forceRollover();
            this.mLogWriter.flush();
            this.mLogWriter.close();
        }
        catch (Exception e) {
            ZimbraLog.redolog.error((Object)("Error closing redo log " + this.mLogFile.getName()), e);
        }
        double rate = 0.0;
        if (this.mCounter > 0) {
            rate = (double)Math.round((double)this.mElapsed / (double)this.mCounter * 1000.0) / 1000.0;
        }
        ZimbraLog.redolog.info("Logged: " + this.mCounter + " items, " + rate + "ms/item");
    }

    public TransactionId getNewTxnId() {
        return this.mTxnIdGenerator.getNext();
    }

    public void log(RedoableOp op, boolean synchronous) {
        if (!this.mEnabled || this.mRecoveryMode) {
            return;
        }
        this.logOnly(op, synchronous);
        if (this.isRolloverNeeded(false)) {
            this.rollover(false, false);
        }
    }

    public void commit(RedoableOp op) {
        if (this.mEnabled) {
            long redoSeq = this.mRolloverMgr.getCurrentSequence();
            CommitTxn commit = new CommitTxn(op);
            this.log(commit, false);
            commit.setSerializedByteArray(null);
        }
    }

    public void abort(RedoableOp op) {
        if (this.mEnabled) {
            AbortTxn abort = new AbortTxn(op);
            this.log(abort, true);
            abort.setSerializedByteArray(null);
        }
    }

    public void flush() throws IOException {
        if (this.mEnabled) {
            this.mLogWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logOnly(RedoableOp op, boolean synchronous) {
        try {
            Sync readLock = this.mRWLock.readLock();
            readLock.acquire();
            try {
                LinkedHashMap<TransactionId, RedoableOp> linkedHashMap = this.mActiveOps;
                synchronized (linkedHashMap) {
                    if (op.isStartMarker()) {
                        this.mActiveOps.put(op.getTransactionId(), op);
                    }
                    if (op.isEndMarker()) {
                        this.mActiveOps.remove(op.getTransactionId());
                    }
                }
                try {
                    long start = System.currentTimeMillis();
                    this.mLogWriter.log(op, op.getInputStream(), synchronous);
                    long elapsed = System.currentTimeMillis() - start;
                    Object object = this.mStatGuard;
                    synchronized (object) {
                        this.mElapsed += elapsed;
                        ++this.mCounter;
                    }
                }
                catch (NullPointerException e) {
                    StackTraceElement[] stack = e.getStackTrace();
                    if (stack == null || stack.length == 0) {
                        ZimbraLog.redolog.warn((Object)"Caught NullPointerException during redo logging, but there is no stack trace in the exception.  If you are running Sun server VM, you could be hitting Java bug 4292742.  (http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4292742)  Re-run the test case with client VM to see the stack trace.", e);
                    }
                    this.signalFatalError(e);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                }
                catch (Throwable e) {
                    ZimbraLog.redolog.error((Object)("Redo logging to logger " + this.mLogWriter.getClass().getName() + " failed"), e);
                    this.signalFatalError(e);
                }
                if (ZimbraLog.redolog.isDebugEnabled()) {
                    ZimbraLog.redolog.debug(op.toString());
                }
                Object var11_16 = null;
                readLock.release();
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                readLock.release();
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            Object object = this.mShuttingDownGuard;
            synchronized (object) {
                if (!this.mShuttingDown) {
                    ZimbraLog.redolog.warn((Object)"InterruptedException while logging", e);
                } else {
                    ZimbraLog.redolog.info("Thread interrupted for shutdown");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpoint() {
        LinkedHashSet<TransactionId> txns = null;
        LinkedHashMap<TransactionId, RedoableOp> linkedHashMap = this.mActiveOps;
        synchronized (linkedHashMap) {
            if (this.mActiveOps.size() == 0) {
                return;
            }
            txns = new LinkedHashSet<TransactionId>();
            for (Map.Entry<TransactionId, RedoableOp> entry : this.mActiveOps.entrySet()) {
                txns.add(entry.getKey());
            }
        }
        Checkpoint ckpt = new Checkpoint(txns);
        this.logOnly(ckpt, true);
    }

    protected boolean isRolloverNeeded(boolean immediate) {
        boolean result = false;
        try {
            if (immediate) {
                result = !this.mLogWriter.isEmpty();
            } else {
                long size = this.mLogWriter.getSize();
                if (size >= this.mLogRolloverHardMaxBytes) {
                    result = true;
                } else if (size >= this.mLogRolloverSoftMaxBytes && size > this.mInitialLogSize) {
                    long createTime;
                    long now = System.currentTimeMillis();
                    long age = now - (createTime = Math.min(this.mLogWriter.getCreateTime(), now));
                    result = age >= this.mLogRolloverMinAgeMillis;
                }
            }
        }
        catch (IOException e) {
            ZimbraLog.redolog.fatal("Unable to get redo log size");
            this.signalFatalError(e);
        }
        return result;
    }

    protected void setRolloverLimits(long minAgeMillis, long softMaxBytes, long hardMaxBytes) {
        this.mLogRolloverMinAgeMillis = minAgeMillis;
        this.mLogRolloverSoftMaxBytes = softMaxBytes;
        this.mLogRolloverHardMaxBytes = hardMaxBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File rollover(boolean force, boolean skipCheckpoint) {
        File rolledOverFile = null;
        Sync writeLock = this.mRWLock.writeLock();
        try {
            writeLock.acquire();
        }
        catch (InterruptedException e) {
            Object object = this.mShuttingDownGuard;
            synchronized (object) {
                if (!this.mShuttingDown) {
                    ZimbraLog.redolog.error((Object)"InterruptedException during log rollover", e);
                } else {
                    ZimbraLog.redolog.debug("Rollover interrupted during shutdown");
                }
            }
            return rolledOverFile;
        }
        try {
            block15: {
                try {
                    if (!this.isRolloverNeeded(force)) break block15;
                    ZimbraLog.redolog.debug("Redo log rollover started");
                    long start = System.currentTimeMillis();
                    Db.getInstance().flushToDisk();
                    if (!skipCheckpoint) {
                        this.checkpoint();
                    }
                    LinkedHashMap<TransactionId, RedoableOp> linkedHashMap = this.mActiveOps;
                    synchronized (linkedHashMap) {
                        rolledOverFile = this.mLogWriter.rollover(this.mActiveOps);
                        this.mInitialLogSize = this.mLogWriter.getSize();
                    }
                    long elapsed = System.currentTimeMillis() - start;
                    ZimbraLog.redolog.info("Redo log rollover took " + elapsed + "ms");
                }
                catch (IOException e) {
                    ZimbraLog.redolog.error("IOException during redo log rollover");
                    this.signalFatalError(e);
                    Object var10_14 = null;
                    writeLock.release();
                }
            }
            Object var10_13 = null;
            writeLock.release();
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            writeLock.release();
            throw throwable;
        }
        return rolledOverFile;
    }

    public File forceRollover() {
        return this.forceRollover(false);
    }

    public File forceRollover(boolean skipCheckpoint) {
        return this.rollover(true, skipCheckpoint);
    }

    public RolloverManager getRolloverManager() {
        return this.mRolloverMgr;
    }

    public long getCurrentLogSequence() {
        return this.mRolloverMgr.getCurrentSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetActiveOps() {
        LinkedHashMap<TransactionId, RedoableOp> linkedHashMap = this.mActiveOps;
        synchronized (linkedHashMap) {
            this.mActiveOps.clear();
        }
    }

    protected Sync acquireExclusiveLock() throws InterruptedException {
        Sync writeLock = this.mRWLock.writeLock();
        writeLock.acquire();
        return writeLock;
    }

    protected void releaseExclusiveLock(Sync exclusiveLock) {
        exclusiveLock.release();
    }

    protected void signalFatalError(Throwable e) {
        Zimbra.halt("Aborting process", e);
    }

    public File[] getArchivedLogsFromSequence(long seq) throws IOException {
        return RolloverManager.getArchiveLogs(this.mArchiveDir, seq);
    }

    public File[] getArchivedLogs() throws IOException {
        return this.getArchivedLogsFromSequence(Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<Set<Long>, CommitId> getChangedMailboxesSince(CommitId cid) throws IOException, MailServiceException {
        Pair<Set<Long>, CommitId> pair;
        HashSet<Long> mailboxes = new HashSet<Long>();
        Sync readLock = this.mRWLock.readLock();
        try {
            readLock.acquire();
        }
        catch (InterruptedException e) {
            Object object = this.mShuttingDownGuard;
            synchronized (object) {
                if (!this.mShuttingDown) {
                    ZimbraLog.redolog.error((Object)"InterruptedException during redo log scan for CommitId", e);
                } else {
                    ZimbraLog.redolog.debug("Redo log scan for CommitId interrupted for shutdown");
                }
                return null;
            }
        }
        File linkDir = null;
        try {
            File[] logs;
            try {
                long seq = cid.getRedoSeq();
                File[] archived = this.getArchivedLogsFromSequence(seq);
                if (archived != null) {
                    logs = new File[archived.length + 1];
                    System.arraycopy(archived, 0, logs, 0, archived.length);
                    logs[archived.length] = this.mLogFile;
                } else {
                    logs = new File[]{this.mLogFile};
                }
                FileLogReader firstLog = new FileLogReader(logs[0]);
                if (firstLog.getHeader().getSequence() != seq) {
                    throw MailServiceException.INVALID_COMMIT_ID(cid.toString());
                }
                String dirName = "tmp-scan-" + System.currentTimeMillis();
                linkDir = new File(this.mLogFile.getParentFile(), dirName);
                if (linkDir.exists()) {
                    int suffix = 1;
                    while (linkDir.exists()) {
                        linkDir = new File(this.mLogFile.getParentFile(), dirName + "-" + suffix);
                    }
                }
                if (!linkDir.mkdir()) {
                    throw new IOException("Unable to create temp dir " + linkDir.getAbsolutePath());
                }
                for (int i = 0; i < logs.length; ++i) {
                    File src = logs[i];
                    File dest = new File(linkDir, logs[i].getName());
                    IO.link((String)src.getAbsolutePath(), (String)dest.getAbsolutePath());
                    logs[i] = dest;
                }
                Object var15_18 = null;
                readLock.release();
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                readLock.release();
                throw throwable;
            }
            long lastSeq = -1L;
            CommitTxn lastCommitTxn = null;
            boolean foundMarker = false;
            for (File logfile : logs) {
                Object var19_24;
                FileLogReader logReader = new FileLogReader(logfile);
                logReader.open();
                lastSeq = logReader.getHeader().getSequence();
                try {
                    try {
                        RedoableOp op = null;
                        while ((op = logReader.getNextOp()) != null) {
                            if (ZimbraLog.redolog.isDebugEnabled()) {
                                ZimbraLog.redolog.debug("Read: " + op);
                            }
                            if (!(op instanceof CommitTxn)) continue;
                            lastCommitTxn = (CommitTxn)op;
                            if (foundMarker) {
                                long mboxId = op.getMailboxId();
                                if (mboxId <= 0L) continue;
                                mailboxes.add(mboxId);
                                continue;
                            }
                            if (!cid.matches(lastCommitTxn)) continue;
                            foundMarker = true;
                        }
                        var19_24 = null;
                    }
                    catch (IOException e) {
                        ZimbraLog.redolog.warn((Object)"IOException while reading redolog file", e);
                        var19_24 = null;
                        logReader.close();
                        continue;
                    }
                    logReader.close();
                }
                catch (Throwable throwable) {
                    var19_24 = null;
                    logReader.close();
                    throw throwable;
                }
            }
            if (!foundMarker) {
                throw MailServiceException.INVALID_COMMIT_ID(cid.toString());
            }
            CommitId lastCommitId = new CommitId(lastSeq, lastCommitTxn);
            pair = new Pair<Set<Long>, CommitId>(mailboxes, lastCommitId);
            Object var21_26 = null;
            if (linkDir == null) return pair;
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            if (linkDir == null) throw throwable;
            try {}
            catch (IOException e) {
                ZimbraLog.redolog.warn((Object)("Unable to delete temporary directory " + linkDir.getAbsolutePath()), e);
                throw throwable;
            }
            if (!linkDir.exists()) throw throwable;
            FileUtil.deleteDir(linkDir);
            throw throwable;
        }
        try {
            if (!linkDir.exists()) return pair;
            FileUtil.deleteDir(linkDir);
            return pair;
        }
        catch (IOException e) {
            ZimbraLog.redolog.warn((Object)("Unable to delete temporary directory " + linkDir.getAbsolutePath()), e);
        }
        return pair;
    }

    private class PostStartupCrashRecoveryThread
    extends Thread {
        List mOps;

        private PostStartupCrashRecoveryThread(List ops) {
            super("PostStartupCrashRecovery");
            this.setDaemon(true);
            this.mOps = ops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ZimbraLog.redolog.info("Starting post-startup crash recovery");
            boolean interrupted = false;
            Iterator iter = this.mOps.iterator();
            while (iter.hasNext()) {
                AbortTxn abort;
                Object var6_6;
                Object object = RedoLogManager.this.mShuttingDownGuard;
                synchronized (object) {
                    if (RedoLogManager.this.mShuttingDown) {
                        interrupted = true;
                        break;
                    }
                }
                RedoableOp op = (RedoableOp)iter.next();
                try {
                    try {
                        if (ZimbraLog.redolog.isDebugEnabled()) {
                            ZimbraLog.redolog.debug("REDOING: " + op);
                        }
                        op.redo();
                    }
                    catch (Exception e) {
                        ZimbraLog.redolog.error((Object)("Redo failed for [" + op + "]." + "  Backend state of affected item is indeterminate." + "  Marking operation as aborted and moving on."), e);
                        var6_6 = null;
                        abort = new AbortTxn(op);
                        RedoLogManager.this.logOnly(abort, true);
                        continue;
                    }
                    var6_6 = null;
                    abort = new AbortTxn(op);
                    RedoLogManager.this.logOnly(abort, true);
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    abort = new AbortTxn(op);
                    RedoLogManager.this.logOnly(abort, true);
                    throw throwable;
                }
            }
            MailboxIndex.flushAllWriters();
            if (!interrupted) {
                ZimbraLog.redolog.info("Finished post-startup crash recovery");
            }
            this.mOps.clear();
            this.mOps = null;
            Object object = RedoLogManager.this.mShuttingDownGuard;
            synchronized (object) {
                RedoLogManager.this.mInPostStartupCrashRecovery = false;
                if (RedoLogManager.this.mShuttingDown) {
                    RedoLogManager.this.mShuttingDownGuard.notifyAll();
                }
            }
        }
    }

    private static class TxnIdGenerator {
        private int mTime;
        private int mCounter;

        public TxnIdGenerator() {
            this.init();
        }

        private void init() {
            this.mTime = (int)(System.currentTimeMillis() / 1000L);
            this.mCounter = 1;
        }

        public synchronized TransactionId getNext() {
            TransactionId tid = new TransactionId(this.mTime, this.mCounter);
            if ((long)this.mCounter < Integer.MAX_VALUE) {
                ++this.mCounter;
            } else {
                this.init();
            }
            return tid;
        }
    }
}

