/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.util.ByteUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RedoLogInput {
    private DataInput mIN;
    private String mPath;

    public RedoLogInput(InputStream is) {
        this.mIN = new DataInputStream(is);
    }

    public RedoLogInput(RandomAccessFile raf, String path) {
        this.mPath = path;
        this.mIN = raf;
    }

    public String getPath() {
        return this.mPath;
    }

    public long getFilePointer() throws IOException {
        if (this.mIN instanceof RandomAccessFile) {
            RandomAccessFile file = (RandomAccessFile)this.mIN;
            return file.getFilePointer();
        }
        return -1L;
    }

    public int skipBytes(int n) throws IOException {
        return this.mIN.skipBytes(n);
    }

    public void readFully(byte[] b) throws IOException {
        this.mIN.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.mIN.readFully(b, off, len);
    }

    public boolean readBoolean() throws IOException {
        return this.mIN.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.mIN.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.mIN.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.mIN.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.mIN.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.mIN.readInt();
    }

    public long readLong() throws IOException {
        return this.mIN.readLong();
    }

    public double readDouble() throws IOException {
        return this.mIN.readDouble();
    }

    public String readUTF() throws IOException {
        return ByteUtil.readUTF8(this.mIN);
    }
}

