/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.util.Config;
import com.zimbra.cs.util.Zimbra;

public class RedoConfig {
    private static RedoConfig theInstance;
    private String mServiceHostname;
    private boolean mRedoLogEnabled;
    private static final boolean D_REDOLOG_ENABLED = true;
    private String mRedoLogPath;
    private static final String D_REDOLOG_PATH = "redolog/redo.log";
    private String mRedoLogArchiveDir;
    private static final String D_REDOLOG_ARCHIVEDIR = "redolog/archive";
    private long mRedoLogRolloverFileSizeKB;
    private static final long D_REDOLOG_ROLLOVER_FILESIZE_KB = 102400L;
    private long mRedoLogRolloverHardMaxFileSizeKB;
    private static final long D_REDOLOG_ROLLOVER_HARDMAX_FILESIZE_KB = 0x100000L;
    private long mRedoLogRolloverMinFileAge;
    private static final long D_REDOLOG_ROLLOVER_MIN_FILE_AGE = 30L;
    private boolean mRedoLogDeleteOnRollover;
    private static final boolean D_REDOLOG_DELETE_ON_ROLLOVER = true;
    private long mRedoLogFsyncIntervalMS;
    private static final long D_REDOLOG_FSYNC_INTERVAL_MS = 10L;
    private long mRedoLogCrashRecoveryLookbackSec;
    private static final long D_REDOLOG_CRASH_RECOVERY_LOOKBACK_SEC = 10L;

    private RedoConfig() throws ServiceException {
        this.reloadInstance();
    }

    private void reloadInstance() throws ServiceException {
        Server config = Provisioning.getInstance().getLocalServer();
        this.mServiceHostname = config.getAttr("zimbraServiceHostname");
        this.mRedoLogEnabled = config.getBooleanAttr("zimbraRedoLogEnabled", true);
        this.mRedoLogPath = Config.getPathRelativeToZimbraHome(config.getAttr("zimbraRedoLogLogPath", D_REDOLOG_PATH)).getAbsolutePath();
        this.mRedoLogArchiveDir = Config.getPathRelativeToZimbraHome(config.getAttr("zimbraRedoLogArchiveDir", D_REDOLOG_ARCHIVEDIR)).getAbsolutePath();
        this.mRedoLogRolloverFileSizeKB = config.getLongAttr("zimbraRedoLogRolloverFileSizeKB", 102400L);
        this.mRedoLogRolloverHardMaxFileSizeKB = config.getLongAttr("zimbraRedoLogRolloverHardMaxFileSizeKB", 0x100000L);
        this.mRedoLogRolloverMinFileAge = config.getLongAttr("zimbraRedoLogRolloverMinFileAge", 30L);
        this.mRedoLogDeleteOnRollover = config.getBooleanAttr("zimbraRedoLogDeleteOnRollover", true);
        this.mRedoLogFsyncIntervalMS = config.getLongAttr("zimbraRedoLogFsyncIntervalMS", 10L);
        this.mRedoLogCrashRecoveryLookbackSec = config.getLongAttr("zimbraRedoLogCrashRecoveryLookbackSec", 10L);
    }

    public static synchronized void reload() throws ServiceException {
        theInstance.reloadInstance();
    }

    public static synchronized String serviceHostname() {
        return RedoConfig.theInstance.mServiceHostname;
    }

    public static synchronized boolean redoLogEnabled() {
        return RedoConfig.theInstance.mRedoLogEnabled;
    }

    public static synchronized String redoLogPath() {
        return RedoConfig.theInstance.mRedoLogPath;
    }

    public static synchronized String redoLogArchiveDir() {
        return RedoConfig.theInstance.mRedoLogArchiveDir;
    }

    public static synchronized long redoLogRolloverFileSizeKB() {
        return RedoConfig.theInstance.mRedoLogRolloverFileSizeKB;
    }

    public static synchronized long redoLogRolloverHardMaxFileSizeKB() {
        return RedoConfig.theInstance.mRedoLogRolloverHardMaxFileSizeKB;
    }

    public static synchronized long redoLogRolloverMinFileAge() {
        return RedoConfig.theInstance.mRedoLogRolloverMinFileAge;
    }

    public static synchronized boolean redoLogDeleteOnRollover() {
        return RedoConfig.theInstance.mRedoLogDeleteOnRollover;
    }

    public static synchronized long redoLogFsyncIntervalMS() {
        return RedoConfig.theInstance.mRedoLogFsyncIntervalMS;
    }

    public static synchronized long redoLogCrashRecoveryLookbackSec() {
        return RedoConfig.theInstance.mRedoLogCrashRecoveryLookbackSec;
    }

    static {
        try {
            theInstance = new RedoConfig();
        }
        catch (ServiceException e) {
            Zimbra.halt("Unable to read redolog configuration", e);
        }
    }
}

