/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.redolog.RedoConfig;
import com.zimbra.cs.redolog.RedoLogManager;
import com.zimbra.cs.redolog.RedoLogProvider;
import java.io.File;

public class DefaultRedoLogProvider
extends RedoLogProvider {
    public boolean isMaster() {
        return true;
    }

    public boolean isSlave() {
        return false;
    }

    public void startup() throws ServiceException {
        this.initRedoLogManager();
        if (RedoConfig.redoLogEnabled()) {
            this.mRedoLogManager.start();
        }
    }

    public void shutdown() throws ServiceException {
        if (RedoConfig.redoLogEnabled()) {
            this.mRedoLogManager.stop();
        }
    }

    public void initRedoLogManager() {
        File redoLog = new File(RedoConfig.redoLogPath());
        File archDir = new File(RedoConfig.redoLogArchiveDir());
        this.mRedoLogManager = new RedoLogManager(redoLog, archDir, true);
    }
}

