/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.redolog.TransactionId;
import com.zimbra.cs.redolog.op.CommitTxn;

public class CommitId {
    private long mRedoSeq;
    private long mTxnTstamp;
    private TransactionId mTxnId;

    private CommitId(long seq, long txnTstamp, TransactionId txnId) {
        this.mRedoSeq = seq;
        this.mTxnTstamp = txnTstamp;
        this.mTxnId = txnId;
    }

    public CommitId(long seq, CommitTxn txn) {
        this(seq, txn.getTimestamp(), txn.getTransactionId());
    }

    public boolean matches(CommitTxn txn) {
        return this.mTxnId.equals(txn.getTransactionId()) && this.mTxnTstamp == txn.getTimestamp();
    }

    public long getRedoSeq() {
        return this.mRedoSeq;
    }

    public String encodeToString() {
        int time = this.mTxnId.getTime();
        int counter = this.mTxnId.getCounter();
        StringBuilder sb = new StringBuilder();
        sb.append(this.mRedoSeq).append('-');
        sb.append(this.mTxnTstamp).append('-');
        sb.append(this.mTxnId.encodeToString());
        return sb.toString();
    }

    public static CommitId decodeFromString(String str) throws ServiceException {
        String[] fields;
        Exception cause = null;
        if (str != null && (fields = str.split("-", 3)) != null && fields.length == 3) {
            try {
                long seq = Long.parseLong(fields[0]);
                long txnTstamp = Long.parseLong(fields[1]);
                TransactionId txnId = TransactionId.decodeFromString(fields[2]);
                return new CommitId(seq, txnTstamp, txnId);
            }
            catch (NumberFormatException e) {
                cause = e;
            }
            catch (ServiceException e) {
                cause = e;
            }
        }
        throw ServiceException.PARSE_ERROR("Invalid CommitId " + str, cause);
    }

    public String toString() {
        return this.encodeToString();
    }
}

