/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.util.NetUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.pop3.Pop3Handler;
import com.zimbra.cs.pop3.Pop3Server;
import com.zimbra.cs.tcpserver.TcpServerInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TcpPop3Handler
extends Pop3Handler {
    private TcpServerInputStream mInputStream;
    private String mRemoteAddress;

    TcpPop3Handler(Pop3Server server) {
        super(server);
    }

    protected boolean setupConnection(Socket connection) throws IOException {
        this.mRemoteAddress = connection.getInetAddress().getHostAddress();
        connection.setSoTimeout(this.mConfig.getMaxIdleSeconds() * 1000);
        this.mInputStream = new TcpServerInputStream(connection.getInputStream());
        this.mOutputStream = new BufferedOutputStream(connection.getOutputStream());
        return this.startConnection(connection.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCommand() throws IOException {
        try {
            boolean bl = this.processCommand(this.mInputStream.readLine());
            Object var3_2 = null;
            if (this.dropConnection) {
                this.dropConnection();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_3 = null;
                if (!this.dropConnection) break block3;
                this.dropConnection();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dropConnection() {
        ZimbraLog.addIpToContext(this.mRemoteAddress);
        try {
            block7: {
                try {
                    if (this.mInputStream != null) {
                        this.mInputStream.close();
                        this.mInputStream = null;
                    }
                    if (this.mOutputStream == null) break block7;
                    this.mOutputStream.close();
                    this.mOutputStream = null;
                }
                catch (IOException e) {
                    if (ZimbraLog.pop.isDebugEnabled()) {
                        ZimbraLog.pop.info((Object)"I/O error while closing connection", e);
                    } else {
                        ZimbraLog.pop.info("I/O error while closing connection: " + e);
                    }
                    Object var3_2 = null;
                    ZimbraLog.clearContext();
                    return;
                }
            }
            Object var3_1 = null;
            ZimbraLog.clearContext();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ZimbraLog.clearContext();
            throw throwable;
        }
    }

    protected void startTLS() throws IOException {
        this.sendOK("Begin TLS negotiation");
        SSLSocketFactory fac = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sock = (SSLSocket)fac.createSocket(this.mConnection, this.mConnection.getInetAddress().getHostName(), this.mConnection.getPort(), true);
        NetUtil.setSSLEnabledCipherSuites(sock, this.mConfig.getSSLExcludeCiphers());
        sock.setUseClientMode(false);
        sock.startHandshake();
        ZimbraLog.pop.debug("suite: " + sock.getSession().getCipherSuite());
        this.mInputStream = new TcpServerInputStream(sock.getInputStream());
        this.mOutputStream = new BufferedOutputStream(sock.getOutputStream());
    }

    protected void completeAuthentication() throws IOException {
        this.mAuthenticator.sendSuccess();
        if (this.mAuthenticator.isEncryptionEnabled()) {
            this.mInputStream = new TcpServerInputStream(this.mAuthenticator.unwrap(this.mConnection.getInputStream()));
            this.mOutputStream = this.mAuthenticator.wrap(this.mConnection.getOutputStream());
        }
    }
}

