/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.common.util.NetUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mina.MinaThreadFactory;
import com.zimbra.cs.pop3.MinaPop3Server;
import com.zimbra.cs.pop3.Pop3Config;
import com.zimbra.cs.pop3.TcpPop3Handler;
import com.zimbra.cs.server.Server;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.tcpserver.TcpServer;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pop3Server
extends TcpServer
implements RealtimeStatsCallback {
    private static Server sPopServer;
    private static Server sPopSSLServer;
    private static final String HANDLER_THREAD_NAME = "Pop3Handler";
    private static ExecutorService sPop3HandlerThreadPool;

    private Pop3Server(Pop3Config config) throws ServiceException {
        super(config.isSSLEnabled() ? "Pop3SSLServer" : "Pop3Server", config);
        ZimbraPerf.addStatsCallback(this);
    }

    @Override
    protected ProtocolHandler newProtocolHandler() {
        return new TcpPop3Handler(this);
    }

    public static void bindServerSocket(String addr, int port, boolean ssl) throws IOException {
        NetUtil.bindServerSocket(addr, port, ssl, MinaPop3Server.isEnabled(), null);
    }

    public static synchronized void startupPop3Server() throws ServiceException {
        if (sPopServer == null) {
            sPopServer = Pop3Server.startServer(false);
        }
    }

    public static synchronized void startupPop3SSLServer() throws ServiceException {
        if (sPopSSLServer == null) {
            sPopSSLServer = Pop3Server.startServer(true);
        }
    }

    private static Server startServer(boolean ssl) throws ServiceException {
        Server server;
        Pop3Config config = new Pop3Config(Provisioning.getInstance(), ssl);
        if (MinaPop3Server.isEnabled()) {
            if (sPop3HandlerThreadPool == null) {
                sPop3HandlerThreadPool = Executors.newFixedThreadPool(config.getNumThreads(), new MinaThreadFactory(HANDLER_THREAD_NAME));
            }
            try {
                server = new MinaPop3Server(config, sPop3HandlerThreadPool);
            }
            catch (IOException e) {
                Zimbra.halt("failed to create MinaPop3Server", e);
                return null;
            }
        } else {
            server = new Pop3Server(config);
        }
        try {
            server.start();
        }
        catch (IOException e) {
            Zimbra.halt("failed to start Pop3Server", e);
        }
        return server;
    }

    public static synchronized void shutdownPop3Servers() {
        if (sPopServer != null) {
            sPopServer.shutdown(10);
            sPopServer = null;
        }
        if (sPopSSLServer != null) {
            sPopSSLServer.shutdown(10);
            sPopSSLServer = null;
        }
    }

    @Override
    public Map<String, Object> getStatData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String statName = this.getConfig().isSSLEnabled() ? "pop_ssl_conn" : "pop_conn";
        data.put(statName, this.numActiveHandlers());
        return data;
    }
}

