/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.pop3.Pop3CmdException;
import com.zimbra.cs.pop3.Pop3Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

class Pop3Mailbox {
    private long mId;
    private int mNumDeleted;
    private long mTotalSize;
    private long mDeletedSize;
    private List<Pop3Message> mMessages;
    private OperationContext mOpContext;
    private static final byte[] POP3_TYPES = new byte[]{5};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Pop3Mailbox(Mailbox mbox, Account acct, String query) throws ServiceException {
        this.mId = mbox.getId();
        this.mNumDeleted = 0;
        this.mDeletedSize = 0L;
        this.mOpContext = new OperationContext(acct);
        if (query == null || query.equals("")) {
            String dateConstraint = acct.getAttr("zimbraPrefPop3DownloadSince");
            Date popSince = dateConstraint == null ? null : DateUtil.parseGeneralizedTime(dateConstraint);
            this.mMessages = mbox.openPop3Folder(this.mOpContext, 2, popSince);
            Iterator<Pop3Message> i$ = this.mMessages.iterator();
            while (i$.hasNext()) {
                Pop3Message p3m = i$.next();
                this.mTotalSize += p3m.getSize();
            }
            return;
        }
        ZimbraQueryResults results = null;
        this.mMessages = new ArrayList<Pop3Message>(500);
        try {
            try {
                results = mbox.search(this.mOpContext, query, POP3_TYPES, SortBy.DATE_DESCENDING, 500);
                while (results.hasNext()) {
                    ZimbraHit hit = results.getNext();
                    if (!(hit instanceof MessageHit)) continue;
                    MessageHit mh = (MessageHit)hit;
                    Message msg = mh.getMessage();
                    this.mTotalSize += msg.getSize();
                    this.mMessages.add(new Pop3Message(msg));
                }
                Object var9_14 = null;
                if (results == null) return;
            }
            catch (IOException e) {
                throw ServiceException.FAILURE(e.getMessage(), e);
            }
            catch (ParseException e) {
                throw ServiceException.FAILURE(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (results == null) throw throwable;
            results.doneWithSearchResults();
            throw throwable;
        }
        results.doneWithSearchResults();
    }

    long getId() {
        return this.mId;
    }

    long getSize() {
        return this.mTotalSize - this.mDeletedSize;
    }

    int getNumMessages() {
        return this.mMessages.size() - this.mNumDeleted;
    }

    int getTotalNumMessages() {
        return this.mMessages.size();
    }

    int getNumDeletedMessages() {
        return this.mNumDeleted;
    }

    Pop3Message getMsg(int index) throws Pop3CmdException {
        if (index < 0 || index >= this.mMessages.size()) {
            throw new Pop3CmdException("invalid message");
        }
        Pop3Message p3m = this.mMessages.get(index);
        return p3m;
    }

    private int parseInt(String s, String message) throws Pop3CmdException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new Pop3CmdException(message);
        }
    }

    Pop3Message getPop3Msg(String msg) throws Pop3CmdException {
        int index = this.parseInt(msg, "unable to parse msg");
        Pop3Message p3m = this.getMsg(index - 1);
        if (p3m.isDeleted()) {
            throw new Pop3CmdException("message is deleted");
        }
        return p3m;
    }

    Message getMessage(String msg) throws Pop3CmdException, ServiceException {
        Pop3Message p3m = this.getPop3Msg(msg);
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mId);
        return mbox.getMessageById(this.mOpContext, p3m.getId());
    }

    public void delete(Pop3Message p3m) {
        if (!p3m.isDeleted()) {
            p3m.mDeleted = true;
            ++this.mNumDeleted;
            this.mDeletedSize += p3m.getSize();
        }
    }

    public int undeleteMarked() {
        int count = 0;
        for (int i = 0; i < this.mMessages.size(); ++i) {
            Pop3Message p3m = this.mMessages.get(i);
            if (!p3m.isDeleted()) continue;
            --this.mNumDeleted;
            this.mDeletedSize -= p3m.getSize();
            p3m.mDeleted = false;
            ++count;
        }
        return count;
    }

    public int deleteMarked(boolean hard) throws ServiceException, Pop3CmdException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mId);
        int count = 0;
        int failed = 0;
        for (Pop3Message p3m : this.mMessages) {
            if (!p3m.isDeleted()) continue;
            try {
                if (hard) {
                    mbox.delete(this.mOpContext, p3m.getId(), (byte)5);
                } else {
                    mbox.move(this.mOpContext, p3m.getId(), (byte)5, 3);
                }
                ++count;
            }
            catch (ServiceException e) {
                ++failed;
            }
            --this.mNumDeleted;
            this.mDeletedSize -= p3m.getSize();
            p3m.mDeleted = false;
        }
        if (count > 0) {
            try {
                mbox.resetRecentMessageCount(this.mOpContext);
            }
            catch (ServiceException e) {
                ZimbraLog.pop.info((Object)"error resetting mailbox recent message count", e);
            }
        }
        if (failed > 0) {
            throw new Pop3CmdException("deleted " + count + "/" + (count + failed) + " message(s)");
        }
        return count;
    }
}

