/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.pop3.MinaPop3Server;
import com.zimbra.cs.pop3.Pop3AuthenticatorUser;
import com.zimbra.cs.pop3.Pop3CmdException;
import com.zimbra.cs.pop3.Pop3Config;
import com.zimbra.cs.pop3.Pop3Mailbox;
import com.zimbra.cs.pop3.Pop3Message;
import com.zimbra.cs.pop3.Pop3Server;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.PlainAuthenticator;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.util.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import org.apache.commons.codec.binary.Base64;

public abstract class Pop3Handler
extends ProtocolHandler {
    static final int MIN_EXPIRE_DAYS = 31;
    static final int MAX_RESPONSE = 512;
    static final int MAX_RESPONSE_TEXT = 505;
    private static final byte[] LINE_SEPARATOR = new byte[]{13, 10};
    private static final String TERMINATOR = ".";
    private static final int TERMINATOR_C = 46;
    private static final byte[] TERMINATOR_BYTE = new byte[]{46};
    protected Pop3Config mConfig;
    protected OutputStream mOutputStream;
    protected boolean mStartedTLS;
    private String mUser;
    private String mQuery;
    private String mAccountId;
    private String mAccountName;
    private Pop3Mailbox mMbx;
    private String mCommand;
    private long mStartTime;
    protected int mState;
    protected boolean dropConnection;
    protected Authenticator mAuthenticator;
    private String mClientAddress;
    private String mOrigRemoteAddress;
    protected static final int STATE_AUTHORIZATION = 1;
    protected static final int STATE_TRANSACTION = 2;
    protected static final int STATE_UPDATE = 3;
    private String mCurrentCommandLine;
    private int mExpire;

    Pop3Handler(Pop3Server server) {
        super(server);
        this.mConfig = (Pop3Config)server.getConfig();
        this.mStartedTLS = this.mConfig.isSSLEnabled();
    }

    Pop3Handler(MinaPop3Server server) {
        super(null);
        this.mConfig = (Pop3Config)server.getConfig();
        this.mStartedTLS = this.mConfig.isSSLEnabled();
    }

    protected String getOrigRemoteIpAddr() {
        return this.mOrigRemoteAddress;
    }

    protected void setOrigRemoteIpAddr(String ip) {
        this.mOrigRemoteAddress = ip;
    }

    protected boolean authenticate() {
        return true;
    }

    protected boolean startConnection(InetAddress remoteAddr) throws IOException {
        ZimbraLog.clearContext();
        this.mClientAddress = remoteAddr.getHostAddress();
        ZimbraLog.addIpToContext(this.mClientAddress);
        ZimbraLog.pop.info("connected");
        if (!Config.userServicesEnabled()) {
            this.dropConnection();
            return false;
        }
        this.sendOK(this.mConfig.getBanner());
        this.mState = 1;
        this.dropConnection = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processCommand(String line) throws IOException {
        boolean bl;
        ZimbraLog.addAccountNameToContext(this.mAccountName);
        ZimbraLog.addIpToContext(this.mClientAddress);
        ZimbraLog.addOrigIpToContext(this.mOrigRemoteAddress);
        if (line != null && this.mAuthenticator != null && !this.mAuthenticator.isComplete()) {
            return this.continueAuthentication(line);
        }
        this.mCommand = null;
        this.mStartTime = 0L;
        this.mCurrentCommandLine = line;
        try {
            try {
                boolean result = this.processCommandInternal();
                if (this.mStartTime > 0L) {
                    ZimbraPerf.STOPWATCH_POP.stop(this.mStartTime);
                    if (this.mCommand != null) {
                        ZimbraPerf.POP_TRACKER.addStat(this.mCommand.toUpperCase(), this.mStartTime);
                    }
                }
                bl = result;
                Object var5_8 = null;
            }
            catch (Pop3CmdException e) {
                this.sendERR(e.getResponse());
                ZimbraLog.pop.debug((Object)e.getMessage(), e);
                boolean bl2 = !this.dropConnection;
                Object var5_9 = null;
                ZimbraLog.clearContext();
                return bl2;
            }
            catch (ServiceException e) {
                this.sendERR(Pop3CmdException.getResponse(e.getMessage()));
                ZimbraLog.pop.debug((Object)e.getMessage(), e);
                boolean bl3 = !this.dropConnection;
                Object var5_10 = null;
                ZimbraLog.clearContext();
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            ZimbraLog.clearContext();
            throw throwable;
        }
        ZimbraLog.clearContext();
        return bl;
    }

    protected boolean processCommandInternal() throws Pop3CmdException, IOException, ServiceException {
        this.mStartTime = System.currentTimeMillis();
        this.mCommand = this.mCurrentCommandLine;
        String arg = null;
        if (this.mCommand == null) {
            this.dropConnection = true;
            ZimbraLog.pop.info("disconnected without quit");
            return false;
        }
        if (!Config.userServicesEnabled()) {
            this.dropConnection = true;
            this.sendERR("Temporarily unavailable");
            return false;
        }
        this.setIdle(false);
        int space = this.mCommand.indexOf(" ");
        if (space > 0) {
            arg = this.mCommand.substring(space + 1);
            this.mCommand = this.mCommand.substring(0, space);
        }
        if (ZimbraLog.pop.isDebugEnabled()) {
            String darg = "PASS".equals(this.mCommand) ? "<BLOCKED>" : arg;
            ZimbraLog.pop.debug("command=%s arg=%s", this.mCommand, darg);
        }
        if (this.mCommand.length() < 1) {
            throw new Pop3CmdException("invalid request. please specify a command");
        }
        if (this.mAccountId != null) {
            try {
                Provisioning prov = Provisioning.getInstance();
                Account acct = prov.get(Provisioning.AccountBy.id, this.mAccountId);
                if (acct == null || !acct.getAccountStatus(prov).equals("active")) {
                    return false;
                }
            }
            catch (ServiceException e) {
                return false;
            }
        }
        char ch = this.mCommand.charAt(0);
        switch (ch) {
            case 'A': 
            case 'a': {
                if ("AUTH".equalsIgnoreCase(this.mCommand)) {
                    this.doAUTH(arg);
                    return true;
                }
            }
            case 'C': 
            case 'c': {
                if (!"CAPA".equalsIgnoreCase(this.mCommand)) break;
                this.doCAPA();
                return true;
            }
            case 'D': 
            case 'd': {
                if (!"DELE".equalsIgnoreCase(this.mCommand)) break;
                this.doDELE(arg);
                return true;
            }
            case 'L': 
            case 'l': {
                if (!"LIST".equalsIgnoreCase(this.mCommand)) break;
                this.doLIST(arg);
                return true;
            }
            case 'N': 
            case 'n': {
                if (!"NOOP".equalsIgnoreCase(this.mCommand)) break;
                this.doNOOP();
                return true;
            }
            case 'P': 
            case 'p': {
                if (!"PASS".equalsIgnoreCase(this.mCommand)) break;
                this.doPASS(arg);
                return true;
            }
            case 'Q': 
            case 'q': {
                if (!"QUIT".equalsIgnoreCase(this.mCommand)) break;
                this.doQUIT();
                return false;
            }
            case 'R': 
            case 'r': {
                if ("RETR".equalsIgnoreCase(this.mCommand)) {
                    this.doRETR(arg);
                    return true;
                }
                if (!"RSET".equalsIgnoreCase(this.mCommand)) break;
                this.doRSET();
                return true;
            }
            case 'S': 
            case 's': {
                if ("STAT".equalsIgnoreCase(this.mCommand)) {
                    this.doSTAT();
                    return true;
                }
                if (!"STLS".equalsIgnoreCase(this.mCommand)) break;
                this.doSTLS();
                return true;
            }
            case 'T': 
            case 't': {
                if (!"TOP".equalsIgnoreCase(this.mCommand)) break;
                this.doTOP(arg);
                return true;
            }
            case 'U': 
            case 'u': {
                if ("UIDL".equalsIgnoreCase(this.mCommand)) {
                    this.doUIDL(arg);
                    return true;
                }
                if (!"USER".equalsIgnoreCase(this.mCommand)) break;
                this.doUSER(arg);
                return true;
            }
            case 'X': 
            case 'x': {
                if (!"XOIP".equalsIgnoreCase(this.mCommand)) break;
                this.doXOIP(arg);
                return true;
            }
        }
        throw new Pop3CmdException("unknown command");
    }

    protected void notifyIdleConnection() {
        ZimbraLog.pop.debug("idle connection");
    }

    protected void sendERR(String response) throws IOException {
        this.sendResponse("-ERR", response, true);
    }

    protected void sendOK(String response) throws IOException {
        this.sendResponse("+OK", response, true);
    }

    private void sendOK(String response, boolean flush) throws IOException {
        this.sendResponse("+OK", response, flush);
    }

    protected void sendContinuation(String s) throws IOException {
        this.sendLine("+ " + s, true);
    }

    private void sendResponse(String status, String msg, boolean flush) throws IOException {
        String response;
        String cl = this.mCurrentCommandLine != null ? this.mCurrentCommandLine : "<none>";
        String string = response = msg == null || msg.length() == 0 ? status : status + " " + msg;
        if (ZimbraLog.pop.isDebugEnabled()) {
            ZimbraLog.pop.debug("%s (%s)", response, cl);
        } else if (status.charAt(0) == '-') {
            if (cl.toUpperCase().startsWith("PASS")) {
                cl = "PASS ****";
            }
            ZimbraLog.pop.info("%s (%s)", response, cl);
        }
        this.sendLine(response, flush);
    }

    private void sendLine(String line) throws IOException {
        this.sendLine(line, true);
    }

    private void sendLine(String line, boolean flush) throws IOException {
        this.mOutputStream.write(line.getBytes());
        this.mOutputStream.write(LINE_SEPARATOR);
        if (flush) {
            this.mOutputStream.flush();
        }
    }

    private void sendMessage(InputStream is, int maxNumBodyLines) throws IOException {
        int c;
        boolean inBody = false;
        int numBodyLines = 0;
        PushbackInputStream stream = new PushbackInputStream(is);
        boolean startOfLine = true;
        int lineLength = 0;
        while ((c = stream.read()) != -1) {
            if (c == 13 || c == 10) {
                int peek;
                if (c == 13 && (peek = stream.read()) != 10 && peek != -1) {
                    stream.unread(peek);
                }
                if (!inBody) {
                    if (lineLength == 0) {
                        inBody = true;
                    }
                } else {
                    ++numBodyLines;
                }
                if (inBody && numBodyLines >= maxNumBodyLines) break;
                startOfLine = true;
                lineLength = 0;
                this.mOutputStream.write(LINE_SEPARATOR);
                continue;
            }
            if (c == 46 && startOfLine) {
                this.mOutputStream.write(c);
            }
            if (startOfLine) {
                startOfLine = false;
            }
            ++lineLength;
            this.mOutputStream.write(c);
        }
        if (lineLength != 0 || maxNumBodyLines == 0) {
            this.mOutputStream.write(LINE_SEPARATOR);
        }
        this.mOutputStream.write(TERMINATOR_BYTE);
        this.mOutputStream.write(LINE_SEPARATOR);
        this.mOutputStream.flush();
    }

    private void doQUIT() throws IOException, ServiceException, Pop3CmdException {
        this.dropConnection = true;
        if (this.mMbx != null && this.mMbx.getNumDeletedMessages() > 0) {
            this.mState = 3;
            int count = this.mMbx.deleteMarked(true);
            this.sendOK("deleted " + count + " message(s)");
        } else {
            this.sendOK(this.mConfig.getGoodbye());
        }
        ZimbraLog.pop.info("quit from client");
    }

    private void doNOOP() throws IOException {
        this.sendOK("yawn");
    }

    private void doRSET() throws Pop3CmdException, IOException {
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        int numUndeleted = this.mMbx.undeleteMarked();
        this.sendOK(numUndeleted + " message(s) undeleted");
    }

    private void doUSER(String user) throws Pop3CmdException, IOException {
        this.checkIfLoginPermitted();
        if (this.mState != 1) {
            throw new Pop3CmdException("this command is only valid in authorization state");
        }
        if (user == null) {
            throw new Pop3CmdException("please specify a user");
        }
        if (user.length() > 1024) {
            throw new Pop3CmdException("username length too long");
        }
        if (user.endsWith("}")) {
            int p = user.indexOf(123);
            if (p != -1) {
                this.mUser = user.substring(0, p);
                this.mQuery = user.substring(p + 1, user.length() - 1);
            } else {
                this.mUser = user;
            }
        } else {
            this.mUser = user;
        }
        this.sendOK("hello " + this.mUser + ", please enter your password");
    }

    private void doPASS(String password) throws Pop3CmdException, IOException {
        this.checkIfLoginPermitted();
        if (this.mState != 1) {
            throw new Pop3CmdException("this command is only valid in authorization state");
        }
        if (this.mUser == null) {
            throw new Pop3CmdException("please specify username first with the USER command");
        }
        if (password == null) {
            throw new Pop3CmdException("please specify a password");
        }
        if (password.length() > 1024) {
            throw new Pop3CmdException("password length too long");
        }
        this.authenticate(this.mUser, null, password, null);
        this.sendOK("server ready");
    }

    private void doAUTH(String arg) throws IOException {
        if (this.isAuthenticated()) {
            this.sendERR("command only valid in AUTHORIZATION state");
            return;
        }
        if (arg == null || arg.length() == 0) {
            this.sendERR("mechanism not specified");
            return;
        }
        int i = arg.indexOf(32);
        String mechanism = i > 0 ? arg.substring(0, i) : arg;
        String initialResponse = i > 0 ? arg.substring(i + 1) : null;
        Pop3AuthenticatorUser authUser = new Pop3AuthenticatorUser(this);
        Authenticator auth = Authenticator.getAuthenticator(mechanism, authUser);
        if (auth == null) {
            this.sendERR("mechanism not supported");
            return;
        }
        this.mAuthenticator = auth;
        this.mAuthenticator.setConnection(this.mConnection);
        if (!this.mAuthenticator.initialize()) {
            this.mAuthenticator = null;
            return;
        }
        if (initialResponse != null) {
            this.continueAuthentication(initialResponse);
        } else {
            this.sendContinuation("");
        }
    }

    private boolean continueAuthentication(String response) throws IOException {
        byte[] b = Base64.decodeBase64((byte[])response.getBytes("us-ascii"));
        this.mAuthenticator.handle(b);
        if (this.mAuthenticator.isComplete()) {
            if (this.mAuthenticator.isAuthenticated()) {
                this.completeAuthentication();
            } else {
                this.mAuthenticator = null;
            }
        }
        return true;
    }

    private boolean isAuthenticated() {
        return this.mState != 1 && this.mAccountId != null;
    }

    protected void authenticate(String username, String authenticateId, String password, Authenticator auth) throws Pop3CmdException {
        String type = auth != null ? "authentication" : "login";
        String mechanism = auth != null ? auth.getMechanism() : "LOGIN";
        try {
            Account acct;
            if (auth == null) {
                auth = new PlainAuthenticator(new Pop3AuthenticatorUser(this));
                authenticateId = username;
            }
            if ((acct = auth.authenticate(username, authenticateId, password, AuthContext.Protocol.pop3, this.getOrigRemoteIpAddr(), null)) == null) {
                throw new Pop3CmdException(type + " failed");
            }
            if (!acct.getBooleanAttr("zimbraPop3Enabled", false)) {
                throw new Pop3CmdException("pop access not enabled for account");
            }
            this.mAccountId = acct.getId();
            this.mAccountName = acct.getName();
            ZimbraLog.addAccountNameToContext(this.mAccountName);
            ZimbraLog.pop.info("user " + this.mAccountName + " authenticated, mechanism=" + mechanism + (this.mStartedTLS ? " [TLS]" : ""));
            Mailbox mailbox = MailboxManager.getInstance().getMailboxByAccount(acct);
            this.mMbx = new Pop3Mailbox(mailbox, acct, this.mQuery);
            this.mState = 2;
            this.mExpire = (int)(acct.getTimeInterval("zimbraMailMessageLifetime", 0L) / 86400000L);
            if (this.mExpire > 0 && this.mExpire < 31) {
                this.mExpire = 31;
            }
        }
        catch (ServiceException e) {
            String code = e.getCode();
            if (code.equals("account.NO_SUCH_ACCOUNT") || code.equals("account.AUTH_FAILED")) {
                throw new Pop3CmdException("invalid username/password");
            }
            if (code.equals("account.CHANGE_PASSWORD")) {
                throw new Pop3CmdException("your password has expired");
            }
            if (code.equals("account.MAINTENANCE_MODE")) {
                throw new Pop3CmdException("your account is having maintenance peformed. please try again later");
            }
            throw new Pop3CmdException(e.getMessage());
        }
    }

    private void checkIfLoginPermitted() throws Pop3CmdException {
        if (!this.mStartedTLS && !this.mConfig.allowCleartextLogins()) {
            throw new Pop3CmdException("only valid after entering TLS mode");
        }
    }

    protected boolean isSSLEnabled() {
        return this.mStartedTLS;
    }

    private void doSTAT() throws Pop3CmdException, IOException {
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        this.sendOK(this.mMbx.getNumMessages() + " " + this.mMbx.getSize());
    }

    private void doSTLS() throws Pop3CmdException, IOException {
        if (this.mConfig.isSSLEnabled()) {
            throw new Pop3CmdException("command not valid over SSL");
        }
        if (this.mState != 1) {
            throw new Pop3CmdException("this command is only valid prior to login");
        }
        if (this.mStartedTLS) {
            throw new Pop3CmdException("command not valid while in TLS mode");
        }
        this.startTLS();
        this.mStartedTLS = true;
    }

    private void doLIST(String msg) throws Pop3CmdException, IOException {
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        if (msg != null) {
            Pop3Message pm = this.mMbx.getPop3Msg(msg);
            this.sendOK(msg + " " + pm.getSize());
        } else {
            this.sendOK(this.mMbx.getNumMessages() + " messages", false);
            int totNumMsgs = this.mMbx.getTotalNumMessages();
            for (int n = 0; n < totNumMsgs; ++n) {
                Pop3Message pm = this.mMbx.getMsg(n);
                if (pm.isDeleted()) continue;
                this.sendLine(n + 1 + " " + pm.getSize(), false);
            }
            this.sendLine(TERMINATOR);
        }
    }

    private void doUIDL(String msg) throws Pop3CmdException, IOException {
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        if (msg != null) {
            Pop3Message pm = this.mMbx.getPop3Msg(msg);
            this.sendOK(msg + " " + pm.getId() + TERMINATOR + pm.getDigest());
        } else {
            this.sendOK(this.mMbx.getNumMessages() + " messages", false);
            int totNumMsgs = this.mMbx.getTotalNumMessages();
            for (int n = 0; n < totNumMsgs; ++n) {
                Pop3Message pm = this.mMbx.getMsg(n);
                if (pm.isDeleted()) continue;
                this.sendLine(n + 1 + " " + pm.getId() + TERMINATOR + pm.getDigest(), false);
            }
            this.sendLine(TERMINATOR);
        }
    }

    private int parseInt(String s, String message) throws Pop3CmdException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new Pop3CmdException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRETR(String msg) throws Pop3CmdException, IOException, ServiceException {
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        if (msg == null) {
            throw new Pop3CmdException("please specify a message");
        }
        Message m = this.mMbx.getMessage(msg);
        InputStream is = null;
        try {
            is = m.getContentStream();
            this.sendOK("message follows", false);
            this.sendMessage(is, Integer.MAX_VALUE);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTOP(String arg) throws Pop3CmdException, IOException, ServiceException {
        int space;
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        int n = space = arg == null ? -1 : arg.indexOf(" ");
        if (space == -1) {
            throw new Pop3CmdException("please specify a message and number of lines");
        }
        String msg = arg.substring(0, space);
        int n2 = this.parseInt(arg.substring(space + 1), "unable to parse number of lines");
        if (n2 < 0) {
            throw new Pop3CmdException("please specify a non-negative value for number of lines");
        }
        if (msg == null || msg.equals("")) {
            throw new Pop3CmdException("please specify a message");
        }
        Message m = this.mMbx.getMessage(msg);
        InputStream is = null;
        try {
            is = m.getContentStream();
            this.sendOK("message top follows", false);
            this.sendMessage(is, n2);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    private void doDELE(String msg) throws Pop3CmdException, IOException {
        if (this.mState != 2) {
            throw new Pop3CmdException("this command is only valid after a login");
        }
        if (msg == null) {
            throw new Pop3CmdException("please specify a message");
        }
        Pop3Message pm = this.mMbx.getPop3Msg(msg);
        this.mMbx.delete(pm);
        this.sendOK("message " + msg + " marked for deletion");
    }

    private void doCAPA() throws IOException {
        this.sendOK("Capability list follows", false);
        this.sendLine("TOP", false);
        this.sendLine("USER", false);
        this.sendLine("UIDL", false);
        if (!this.mConfig.isSSLEnabled()) {
            this.sendLine("STLS", false);
        }
        this.sendLine("SASL" + this.getSaslCapabilities(), false);
        if (this.mState != 2) {
            this.sendLine("EXPIRE 31 USER", false);
        } else if (this.mExpire == 0) {
            this.sendLine("EXPIRE NEVER", false);
        } else {
            this.sendLine("EXPIRE " + this.mExpire, false);
        }
        this.sendLine("XOIP", false);
        this.sendLine("IMPLEMENTATION ZimbraInc", false);
        this.sendLine(TERMINATOR);
    }

    private void doXOIP(String origIp) throws Pop3CmdException, IOException {
        if (origIp == null) {
            throw new Pop3CmdException("please specify an ip address");
        }
        String curOrigRemoteIp = this.getOrigRemoteIpAddr();
        if (curOrigRemoteIp == null) {
            this.setOrigRemoteIpAddr(origIp);
            ZimbraLog.addOrigIpToContext(origIp);
            ZimbraLog.pop.info("POP3 client identified as: " + origIp);
        } else if (curOrigRemoteIp.equals(origIp)) {
            ZimbraLog.pop.warn("POP3 XOIP is allowed only once per session, command ignored");
        } else {
            ZimbraLog.pop.error("POP3 XOIP is allowed only once per session, received different IP: " + origIp + ", command ignored");
        }
        this.sendOK("");
    }

    private String getSaslCapabilities() {
        Pop3AuthenticatorUser authUser = new Pop3AuthenticatorUser(this);
        StringBuilder sb = new StringBuilder();
        for (String mechanism : Authenticator.listMechanisms()) {
            if (Authenticator.getAuthenticator(mechanism, authUser) == null) continue;
            sb.append(' ').append(mechanism);
        }
        return sb.toString();
    }

    protected abstract void startTLS() throws IOException;

    protected abstract void completeAuthentication() throws IOException;
}

