/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.server.ServerConfig;
import com.zimbra.cs.util.BuildInfo;

public class Pop3Config
extends ServerConfig {
    private String mBanner;
    private String mGoodbye;
    private boolean mSaslGssapiEnabled;
    private static final int DEFAULT_NUM_THREADS = 10;
    private static final int DEFAULT_MAX_IDLE_SECONDS = 600;
    private static final int DEFAULT_BIND_PORT = 110;
    private static final int DEFAULT_SSL_BIND_PORT = 995;

    public Pop3Config() {
        this.setNumThreads(10);
        this.setMaxIdleSeconds(600);
    }

    public Pop3Config(Provisioning prov, boolean ssl) throws ServiceException {
        Server server = prov.getLocalServer();
        String name = server.getAttr("zimbraPop3AdvertisedName");
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        this.setMaxIdleSeconds(600);
        this.setNumThreads(server.getIntAttr("zimbraPop3NumThreads", 10));
        Config config = prov.getConfig();
        this.setSSLExcludeCiphers(config.getMultiAttr("zimbraSSLExcludeCipherSuites"));
        if (ssl) {
            this.setSSLEnabled(ssl);
            this.setBindAddress(server.getAttr("zimbraPop3SSLBindAddress"));
            this.setBindPort(server.getIntAttr("zimbraPop3SSLBindPort", 995));
        } else {
            this.setBindAddress(server.getAttr("zimbraPop3BindAddress"));
            this.setBindPort(server.getIntAttr("zimbraPop3BindPort", 110));
        }
        this.mSaslGssapiEnabled = server.getBooleanAttr("zimbraPop3SaslGssapiEnabled", false);
        this.validate();
    }

    public void setName(String name) {
        super.setName(name);
        String version = "";
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            if (server.getBooleanAttr("zimbraPop3ExposeVersionOnBanner", false)) {
                version = " " + BuildInfo.VERSION;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.mBanner = name + " Zimbra" + version + " POP3 server ready";
        this.mGoodbye = name + " closing connection";
    }

    public String getBanner() {
        return this.mBanner;
    }

    public String getGoodbye() {
        return this.mGoodbye;
    }

    public boolean allowCleartextLogins() {
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            return server.getBooleanAttr("zimbraPop3CleartextLoginEnabled", false);
        }
        catch (ServiceException e) {
            ZimbraLog.pop.warn((Object)"Unable to determine state of zimbraPop3CleartextLoginEnabled", e);
            return false;
        }
    }

    public boolean isSaslGssapiEnabled() {
        return this.mSaslGssapiEnabled;
    }
}

