/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.pop3.Pop3CmdException;
import com.zimbra.cs.pop3.Pop3Handler;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.AuthenticatorUser;
import java.io.IOException;

class Pop3AuthenticatorUser
implements AuthenticatorUser {
    private final Pop3Handler mHandler;

    Pop3AuthenticatorUser(Pop3Handler handler) {
        this.mHandler = handler;
    }

    public String getProtocol() {
        return "pop";
    }

    public void sendBadRequest(String s) throws IOException {
        this.mHandler.sendERR(s);
    }

    public void sendFailed() throws IOException {
        this.mHandler.sendERR("authentication failed");
    }

    public void sendFailed(String msg) throws IOException {
        this.mHandler.sendERR("authentication failed: " + msg);
    }

    public void sendSuccessful() throws IOException {
        this.mHandler.sendOK("authentication successful");
    }

    public void sendContinuation(String s) throws IOException {
        this.mHandler.sendContinuation(s);
    }

    public boolean authenticate(String authorizationId, String authenticationId, String password, Authenticator auth) throws IOException {
        try {
            this.mHandler.authenticate(authorizationId, authenticationId, password, auth);
        }
        catch (Pop3CmdException e) {
            auth.sendFailed(e.getMessage());
            return false;
        }
        return true;
    }

    public Log getLog() {
        return ZimbraLog.pop;
    }

    public boolean isSSLEnabled() {
        return this.mHandler.isSSLEnabled();
    }

    public boolean allowCleartextLogin() {
        return this.mHandler.mConfig.allowCleartextLogins();
    }

    public boolean isGssapiAvailable() {
        return this.mHandler.mConfig.isSaslGssapiEnabled();
    }
}

