/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mina.MinaCodecFactory;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaServer;
import com.zimbra.cs.pop3.MinaPop3Decoder;
import com.zimbra.cs.pop3.MinaPop3Handler;
import com.zimbra.cs.server.ServerConfig;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;

public class MinaPop3Server
extends MinaServer {
    public static boolean isEnabled() {
        return Boolean.getBoolean("ZimbraNioPop3Enabled") || LC.nio_pop3_enabled.booleanValue();
    }

    MinaPop3Server(ServerConfig config, ExecutorService pool) throws IOException, ServiceException {
        super(config, pool);
    }

    public MinaHandler createHandler(IoSession session) {
        return new MinaPop3Handler(this, session);
    }

    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaCodecFactory(this){

            public ProtocolDecoder getDecoder() {
                return new MinaPop3Decoder(MinaPop3Server.this.getStats());
            }
        };
    }

    public Log getLog() {
        return ZimbraLog.pop;
    }
}

