/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaIoSessionOutputStream;
import com.zimbra.cs.mina.MinaOutputStream;
import com.zimbra.cs.mina.MinaServer;
import com.zimbra.cs.pop3.MinaPop3Server;
import com.zimbra.cs.pop3.Pop3Handler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

public class MinaPop3Handler
extends Pop3Handler
implements MinaHandler {
    private IoSession mSession;
    private static final long WRITE_TIMEOUT = 5000L;

    public MinaPop3Handler(MinaPop3Server server, IoSession session) {
        super(server);
        this.mSession = session;
        this.mOutputStream = new MinaIoSessionOutputStream(this.mSession);
        this.mSession.setIdleTime(IdleStatus.BOTH_IDLE, this.mConfig.getMaxIdleSeconds());
    }

    public void connectionOpened() throws IOException {
        this.startConnection(((InetSocketAddress)this.mSession.getRemoteAddress()).getAddress());
    }

    public void connectionClosed() throws IOException {
        this.mSession.close();
    }

    public void connectionIdle() {
        ZimbraLog.pop.debug("idle connection");
        this.dropConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Object msg) throws IOException {
        try {
            this.processCommand((String)msg);
            Object var3_2 = null;
            if (this.dropConnection) {
                this.dropConnection();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.dropConnection) {
                this.dropConnection();
            }
            throw throwable;
        }
    }

    protected void startTLS() throws IOException {
        MinaServer.startTLS(this.mSession, this.mConfig);
        this.sendOK("Begin TLS negotiation");
    }

    protected void dropConnection() {
        this.dropConnection(5000L);
    }

    public void dropConnection(long timeout) {
        if (!this.mSession.isConnected()) {
            return;
        }
        try {
            this.mOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (timeout >= 0L && !((MinaOutputStream)this.mOutputStream).join(timeout)) {
            ZimbraLog.pop.warn("Force closing session because write timed out: " + this.mSession);
        }
        this.mSession.close();
    }

    protected boolean setupConnection(Socket connection) {
        throw new UnsupportedOperationException();
    }

    protected boolean processCommand() {
        throw new UnsupportedOperationException();
    }

    protected void completeAuthentication() throws IOException {
        if (this.mAuthenticator.isEncryptionEnabled()) {
            MinaServer.addSaslFilter(this.mSession, this.mAuthenticator.getSaslServer());
        }
        this.mAuthenticator.sendSuccess();
    }
}

