/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.pop3;

import com.zimbra.cs.mina.LineBuffer;
import com.zimbra.cs.mina.MinaStats;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class MinaPop3Decoder
extends ProtocolDecoderAdapter {
    private final MinaStats stats;
    private final LineBuffer lbuf = new LineBuffer();

    MinaPop3Decoder(MinaStats stats) {
        this.stats = stats;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) {
        java.nio.ByteBuffer bb = in.buf();
        while (bb.hasRemaining()) {
            if (!this.lbuf.parse(bb)) continue;
            out.write((Object)this.lbuf.toString().trim());
            if (this.stats != null) {
                this.stats.receivedBytes.addAndGet(this.lbuf.size());
            }
            this.lbuf.reset();
        }
    }
}

