/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.operation;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler {
    int[] mTargetLoad = new int[5];
    int[] mMaxSimultaneousOperations = new int[5];
    volatile int mCurLoad;
    volatile int mTotalRunningOperations;
    volatile int[] mRunningOperations = new int[5];
    private static final Scheduler[] sScheduler = new Scheduler[1];
    static final int MIN_LOAD = 1;
    ReentrantLock mLock = new ReentrantLock();
    List<AsyncOperation>[] mOpQueue = new ArrayList[5];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(IOperation op) throws ServiceException {
        this.mLock.lock();
        try {
            int level = op.getPriority().getLevel();
            if (this.opIsRunnable(op, null)) {
                this.startRunning(op);
            } else {
                BlockedOperation blockedThread = new BlockedOperation(op, this);
                this.mOpQueue[level].add(blockedThread);
                blockedThread.await();
                assert (this.mLock.isHeldByCurrentThread());
                assert (!this.mOpQueue[op.getPriority().getLevel()].contains(op));
            }
            Object var5_4 = null;
            this.mLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mLock.unlock();
            throw throwable;
        }
    }

    public void runCompleted(IOperation op) {
        this.mLock.lock();
        try {
            --this.mTotalRunningOperations;
            int n = op.getPriority().getLevel();
            this.mRunningOperations[n] = this.mRunningOperations[n] - 1;
            if (ZimbraLog.op.isDebugEnabled()) {
                ZimbraLog.op.debug("Thread: " + Thread.currentThread().getName() + " runCompleted (1) " + this.mTotalRunningOperations + " running");
            }
            this.mCurLoad -= op.getLoad();
            while (true) {
                AsyncOperation toRun = this.getNextRunnableBlockedOperation();
                assert (toRun != op);
                if (toRun == null) {
                    Object var4_3 = null;
                    this.mLock.unlock();
                    return;
                }
                this.startRunning(toRun);
                toRun.signal();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mLock.unlock();
            throw throwable;
        }
    }

    public static Scheduler get(Mailbox mbox) {
        if (mbox == null) {
            return sScheduler[0];
        }
        return sScheduler[(int)(mbox.getId() % (long)sScheduler.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleAsync(AsyncOperation op) throws ServiceException {
        block3: {
            this.mLock.lock();
            try {
                if (!this.opIsRunnable(op, null)) break block3;
                this.startRunning(op);
                boolean bl = true;
                Object var4_4 = null;
                this.mLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.mLock.unlock();
                throw throwable;
            }
        }
        this.mOpQueue[op.getPriority().getLevel()].add(op);
        boolean bl = false;
        Object var4_5 = null;
        this.mLock.unlock();
        return bl;
    }

    private void startRunning(IOperation op) {
        assert (this.mLock.isHeldByCurrentThread());
        if (ZimbraLog.op.isDebugEnabled()) {
            ZimbraLog.op.debug("Thread: " + Thread.currentThread().getName() + " startRunning() " + this.mTotalRunningOperations + " running");
        }
        ++this.mTotalRunningOperations;
        int n = op.getPriority().getLevel();
        this.mRunningOperations[n] = this.mRunningOperations[n] + 1;
        this.mCurLoad += op.getLoad();
    }

    private boolean opIsRunnable(IOperation op, List<AsyncOperation> queue) throws ServiceException {
        assert (this.mLock.isHeldByCurrentThread());
        if (this.mTotalRunningOperations == 0 || this.mCurLoad == 0) {
            if (queue != null) {
                IOperation removed = queue.remove(0);
                if (ZimbraLog.op.isDebugEnabled()) {
                    ZimbraLog.op.debug("Removing: " + removed.toString());
                }
                assert (removed == op);
            }
            return true;
        }
        int level = op.getPriority().getLevel();
        if (op.getPriority() == Priority.ADMIN || this.mTotalRunningOperations + 1 < this.mMaxSimultaneousOperations[level]) {
            int loadLeft = this.mTargetLoad[level] - this.mCurLoad;
            if (op.getLoad() < loadLeft) {
                if (queue != null) {
                    IOperation removed = queue.remove(0);
                    if (ZimbraLog.op.isDebugEnabled()) {
                        ZimbraLog.op.debug("Removing: " + removed.toString());
                    }
                    assert (removed == op);
                }
                return true;
            }
        }
        return false;
    }

    private AsyncOperation getNextRunnableBlockedOperation() {
        assert (this.mLock.isHeldByCurrentThread());
        for (Priority pri : Priority.values()) {
            List<AsyncOperation> queue = this.mOpQueue[pri.getLevel()];
            if (queue.isEmpty()) continue;
            AsyncOperation op = queue.get(0);
            try {
                if (this.opIsRunnable(op, queue)) {
                    return op;
                }
                return null;
            }
            catch (ServiceException ex) {
                op.setException(ex);
                return op;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpQueues() {
        this.mLock.lock();
        try {
            int i;
            StringBuilder toRet = new StringBuilder();
            for (i = 0; i < this.mTargetLoad.length; ++i) {
                toRet.append("TargetLoad[").append(i).append("] = ").append(this.mTargetLoad).append('\n');
            }
            toRet.append("MaxOps =").append(this.mMaxSimultaneousOperations).append(' ');
            toRet.append("CurLoad=").append(this.mCurLoad).append(' ');
            assert (this.mLock.isHeldByCurrentThread());
            toRet.append("Running=").append(this.mTotalRunningOperations).append("\n\t");
            for (i = 0; i < this.mRunningOperations.length; ++i) {
                toRet.append(this.mRunningOperations[i]).append(", ");
            }
            toRet.append('\n');
            for (Priority pri : Priority.values()) {
                List<AsyncOperation> queue = this.mOpQueue[pri.getLevel()];
                toRet.append('\t').append((Object)pri).append(':');
                for (AsyncOperation op : queue) {
                    toRet.append(op.toString()).append(' ');
                }
                toRet.append('\n');
            }
            String string = toRet.toString();
            Object var10_10 = null;
            this.mLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.mLock.unlock();
            throw throwable;
        }
    }

    public static int[] readOpsFromString(String str) {
        int[] toRet = new int[5];
        String[] strs = str.split(",");
        if (strs.length < 5) {
            return null;
        }
        for (int i = 0; i < 5; ++i) {
            try {
                toRet[i] = Integer.parseInt(strs[i]);
                if (toRet[i] > 0) continue;
                ZimbraLog.system.warn("Error parsing zimbra_throttle_op_concurrency (\"" + str + "\")");
                return null;
            }
            catch (NumberFormatException e) {
                ZimbraLog.system.warn("Error parsing zimbra_throttle_op_concurrency (\"" + str + "\")");
                return null;
            }
        }
        return toRet;
    }

    private static int[] readOpsFromLC() {
        String value = LC.zimbra_throttle_op_concurrency.value();
        return Scheduler.readOpsFromString(value);
    }

    protected Scheduler(int targetLoad, int[] maxOps) {
        int i;
        for (i = 0; i < 5; ++i) {
            this.mOpQueue[i] = new ArrayList<AsyncOperation>();
        }
        this.setParams(targetLoad, maxOps);
        for (i = 0; i < 5; ++i) {
            ZimbraLog.op.info("\t\tPRIORITY " + i + " ==> " + this.mMaxSimultaneousOperations[i]);
        }
    }

    public static void setConcurrency(int[] maxOps) {
        for (Scheduler s : sScheduler) {
            s.setMaxOps(maxOps);
        }
    }

    private void setMaxOps(int[] maxOps) {
        this.mMaxSimultaneousOperations = maxOps;
    }

    public int[] getMaxOps() {
        int[] toRet = new int[this.mMaxSimultaneousOperations.length];
        System.arraycopy(this.mMaxSimultaneousOperations, 0, toRet, 0, this.mMaxSimultaneousOperations.length);
        return toRet;
    }

    private void setParams(int targetLoad, int[] maxOps) {
        this.setMaxOps(maxOps);
        if (targetLoad < 1) {
            targetLoad = 1;
        }
        this.mTargetLoad[4] = targetLoad;
        for (int i = 3; i >= 0; --i) {
            this.mTargetLoad[i] = targetLoad *= 2;
        }
    }

    public static void setSchedulerParams(int targetLoad, int[] maxOps) {
        int curSched = 0;
        for (Scheduler s : sScheduler) {
            s.setParams(targetLoad, maxOps);
            StringBuilder str = new StringBuilder("Scheduler(");
            str.append(curSched++).append(") : setting maxOps=").append(Arrays.toString(maxOps));
            str.append(" MaxLoads={");
            for (int i = 0; i < 5; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(s.mTargetLoad[i]);
            }
            str.append('}');
            ZimbraLog.system.info(str.toString());
        }
    }

    ReentrantLock getLock() {
        return this.mLock;
    }

    public static void main(String[] args) {
        Scheduler s = new Scheduler(30, new int[]{10000, 10000, 10000, 10000, 10000});
        int NUMTHREADS = 30;
        SearchTestThread[] t = new SearchTestThread[NUMTHREADS];
        for (int i = 0; i < NUMTHREADS; ++i) {
            t[i] = new SearchTestThread(s, Integer.toString(i));
            new Thread(t[i]).start();
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                    System.out.println("SCHEDULER:\n" + s.dumpQueues());
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    static {
        int[] defaultOpsConcurrency = new int[]{10000, 10000, 10000, 10000, 10000};
        int[] ops = Scheduler.readOpsFromLC();
        if (ops == null) {
            ops = defaultOpsConcurrency;
        }
        Scheduler.sScheduler[0] = new Scheduler(10000, ops);
    }

    static class SearchTestThread
    extends TestOperation
    implements Runnable {
        Scheduler mSched;
        long mCount;
        String mName;

        SearchTestThread(Scheduler s, String name) {
            super("Search", Priority.INTERACTIVE_HIGH, 1);
            this.mSched = s;
            this.mName = name;
        }

        public String toString() {
            return "SearchTestThread" + this.mName + " " + super.toString();
        }

        public void execute() {
            for (long i = 0L; i < 1000000L; ++i) {
                ++this.mCount;
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (long i = 0L; i < 1000000L; ++i) {
                ++this.mCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Object var2_4;
                    this.mSched.schedule(this);
                    try {
                        this.execute();
                        var2_4 = null;
                        this.mSched.runCompleted(this);
                    }
                    catch (Throwable throwable) {
                        var2_4 = null;
                        this.mSched.runCompleted(this);
                        throw throwable;
                    }
                }
                catch (ServiceException e) {
                    System.out.println("Caught except: " + e.toString());
                    e.printStackTrace();
                    return;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    static class TestOperation
    implements IOperation {
        protected String mOpType;
        protected Priority mPriority;
        protected int mLoad;

        TestOperation(String optype, Priority pri, int load) {
            this.mOpType = optype;
            this.mPriority = pri;
            this.mLoad = load;
        }

        public int getLoad() {
            return this.mLoad;
        }

        public Priority getPriority() {
            return this.mPriority;
        }

        public String getName() {
            return this.mOpType;
        }
    }

    private static class BlockedOperation
    extends ThreadedOperation {
        protected IOperation mOp;

        BlockedOperation(IOperation op, Scheduler sched) {
            super(sched);
            this.mOp = op;
        }

        public String getName() {
            return this.mOp.getName();
        }

        public Priority getPriority() {
            return this.mOp.getPriority();
        }

        public int getLoad() {
            return this.mOp.getLoad();
        }
    }

    static abstract class ThreadedOperation
    implements AsyncOperation {
        protected volatile boolean mSignaled = false;
        protected volatile ServiceException mException = null;
        protected ReentrantLock mLock = null;
        protected Condition mCond = null;

        ThreadedOperation(Scheduler sched) {
            this.mLock = sched.getLock();
            this.mCond = this.mLock.newCondition();
        }

        public void await() throws ServiceException {
            assert (this.mLock.isHeldByCurrentThread());
            this.mSignaled = false;
            do {
                try {
                    if (ZimbraLog.op.isDebugEnabled()) {
                        ZimbraLog.op.debug(Thread.currentThread().getName() + ": Waiting on cond: " + this.mCond.toString() + " for lock " + this.mLock);
                    }
                    this.mCond.await();
                    if (!ZimbraLog.op.isDebugEnabled()) continue;
                    ZimbraLog.op.debug(Thread.currentThread().getName() + ":  EXITING COND:  " + this.mCond.toString() + " for lock " + this.mLock);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.mSignaled);
            if (this.mException != null) {
                throw this.mException;
            }
        }

        public void signal() {
            assert (this.mLock.isHeldByCurrentThread());
            this.mSignaled = true;
            assert (this.mCond != null);
            if (ZimbraLog.op.isDebugEnabled()) {
                ZimbraLog.op.debug("Signalling on cond: " + this.mCond.toString());
            }
            this.mCond.signal();
        }

        public void setException(ServiceException e) {
            this.mException = e;
        }

        public String toString() {
            return "OP(" + this.getName().toString() + "," + (Object)((Object)this.getPriority()) + "," + this.getLoad() + ")";
        }
    }

    public static interface AsyncOperation
    extends IOperation {
        public void signal();

        public void setException(ServiceException var1);
    }

    public static interface IOperation {
        public String getName();

        public Priority getPriority();

        public int getLoad();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority ADMIN = new Priority(0);
        public static final /* enum */ Priority INTERACTIVE_HIGH = new Priority(1);
        public static final /* enum */ Priority INTERACTIVE_LOW = new Priority(2);
        public static final /* enum */ Priority BATCH = new Priority(3);
        public static final /* enum */ Priority LOW = new Priority(4);
        public static final int NUM_PRIORITIES = 5;
        private int mLevel;
        private static final /* synthetic */ Priority[] $VALUES;

        public static final Priority[] values() {
            return (Priority[])$VALUES.clone();
        }

        public static Priority valueOf(String name) {
            return Enum.valueOf(Priority.class, name);
        }

        private Priority(int level) {
            this.mLevel = level;
        }

        private int getLevel() {
            return this.mLevel;
        }

        public Priority increment() {
            switch (this.mLevel) {
                case 0: {
                    return ADMIN;
                }
                case 1: {
                    return ADMIN;
                }
                case 2: {
                    return INTERACTIVE_HIGH;
                }
                case 3: {
                    return INTERACTIVE_LOW;
                }
                case 4: {
                    return BATCH;
                }
            }
            assert (false);
            return null;
        }

        public Priority decrement() {
            switch (this.mLevel) {
                case 0: {
                    return INTERACTIVE_HIGH;
                }
                case 1: {
                    return INTERACTIVE_LOW;
                }
                case 2: {
                    return BATCH;
                }
                case 3: {
                    return LOW;
                }
                case 4: {
                    return LOW;
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new Priority[]{ADMIN, INTERACTIVE_HIGH, INTERACTIVE_LOW, BATCH, LOW};
        }
    }
}

