/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.operation;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.operation.Requester;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.session.Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
implements Scheduler.IOperation {
    public static Map<String, Config> mConfigMap = Collections.synchronizedMap(new HashMap());
    protected static final int OPERATION_REPEAT_THRESHOLD = 3;
    protected Scheduler.Priority mPriority;
    protected int mLoad;
    protected Session mSession;
    protected OperationContext mOpCtxt;
    protected Mailbox mMailbox;
    protected Scheduler mSched;
    protected Requester mReq;

    public static Config loadConfig(Class c) {
        if (mConfigMap.containsKey(c.getCanonicalName())) {
            return mConfigMap.get(c.getCanonicalName());
        }
        if (mConfigMap.containsKey(c.getSimpleName())) {
            return mConfigMap.get(c.getSimpleName());
        }
        return null;
    }

    public static int setLoad(Class c, int defaultLoad) {
        Config conf = Operation.loadConfig(c);
        if (conf != null) {
            return conf.mLoad;
        }
        return defaultLoad;
    }

    protected Operation(Session session, OperationContext oc, Mailbox mbox, Requester req, Scheduler.Priority basePriority, int load) {
        this.init(session, oc, mbox, req, basePriority, load);
    }

    protected Operation(Session session, OperationContext oc, Mailbox mbox, Requester req, int load) {
        this(session, oc, mbox, req, req.getPriority(), load);
    }

    protected Operation() {
    }

    protected void init(Session session, OperationContext oc, Mailbox mbox, Requester req, Scheduler.Priority basePriority, int load) {
        this.mSession = session;
        this.mOpCtxt = oc;
        this.mMailbox = mbox;
        this.mPriority = this.calcPriority(basePriority);
        this.mLoad = load;
        this.mReq = req;
    }

    protected abstract void callback() throws ServiceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void schedule() throws ServiceException {
        if (ZimbraLog.op.isDebugEnabled()) {
            ZimbraLog.op.debug("Scheduling " + this.toSchedulingString());
        }
        this.mSched = Scheduler.get(this.mMailbox);
        this.mSched.schedule(this);
        if (this.mSession != null) {
            this.mSession.logOperation(this);
        }
        long start = 0L;
        try {
            if (ZimbraLog.op.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            if (ZimbraLog.op.isDebugEnabled()) {
                ZimbraLog.op.debug("Executing:  " + this.toExecutingString());
            }
            this.callback();
            Object var4_2 = null;
            this.mSched.runCompleted(this);
            if (!ZimbraLog.op.isInfoEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.mSched.runCompleted(this);
            if (!ZimbraLog.op.isInfoEnabled()) throw throwable;
            long end = System.currentTimeMillis();
            ZimbraLog.op.info("Completed(" + (end - start) + "ms): " + this.toCompletedString());
            throw throwable;
        }
        long end = System.currentTimeMillis();
        ZimbraLog.op.info("Completed(" + (end - start) + "ms): " + this.toCompletedString());
    }

    public void runImmediately() throws ServiceException {
        this.callback();
    }

    protected String toSchedulingString() {
        return this.toString();
    }

    protected String toExecutingString() {
        return this.toString();
    }

    protected String toCompletedString() {
        return this.toString();
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder(this.getClassName());
        toRet.append(" Req=").append(this.mReq.toString());
        if (this.mMailbox != null) {
            toRet.append(" Mbox=").append(this.mMailbox.getId());
        }
        if (this.mSession != null) {
            toRet.append(" Session=").append(this.mSession.getSessionId());
        }
        toRet.append(" Pri=").append(this.mPriority.toString());
        toRet.append(" Load=").append(this.mLoad);
        return toRet.toString();
    }

    protected Scheduler.Priority calcPriority(Scheduler.Priority basePriority) {
        List<Session.RecentOperation> recentOps;
        Scheduler.Priority toRet = basePriority;
        if (this.mSession != null && this.isRepeatedOperation(recentOps = this.mSession.getRecentOperations())) {
            toRet = toRet.decrement();
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRepeatedOperation(List<Session.RecentOperation> recentOps) {
        List<Session.RecentOperation> list = recentOps;
        synchronized (list) {
            int counted = 0;
            for (Session.RecentOperation rop : recentOps) {
                if (rop.mOperationClass != this.getClass()) continue;
                ++counted;
            }
            return counted >= 3;
        }
    }

    protected Log getLog() {
        return ZimbraLog.op;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getLoad() {
        return this.mLoad;
    }

    public Mailbox getMailbox() {
        return this.mMailbox;
    }

    public OperationContext getOpCtxt() {
        return this.mOpCtxt;
    }

    @Override
    public Scheduler.Priority getPriority() {
        return this.mPriority;
    }

    public Requester getRequester() {
        return this.mReq;
    }

    public Scheduler getScheduler() {
        return this.mSched;
    }

    public Session getSession() {
        return this.mSession;
    }

    public static class Config {
        public int mLoad;
        public int mScale;
        public int mMaxLoad;
    }
}

