/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.operation;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.operation.Operation;
import java.io.File;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class ConfigLoader {
    private static final String E_SCHEDULER = "scheduler";
    private static final String E_CONFIG = "config";
    private static final String A_MAX_LOAD = "maxload";
    private static final String A_LOAD = "load";
    private static final String A_MAX_OPS = "maxops";
    private static final String E_OP = "op";
    private static final String A_NAME = "name";
    private static final String A_SCALE = "scale";

    private static String defaultConfigFile() {
        String zmHome = System.getProperty("zimbra.home");
        if (zmHome == null) {
            zmHome = File.separator + "opt" + File.separator + "zimbra";
        }
        return zmHome + File.separator + "conf" + File.separator + "schedconfig.xml";
    }

    public static void loadConfig() throws ServiceException {
        String configFile = ConfigLoader.defaultConfigFile();
        try {
            File cf = new File(configFile);
            if (cf.exists() && cf.canRead()) {
                SAXReader reader = Element.getSAXReader();
                Document document = reader.read(cf);
                org.dom4j.Element root = document.getRootElement();
                if (!root.getName().equals(E_SCHEDULER)) {
                    throw new DocumentException("config file " + configFile + " root tag is not " + E_SCHEDULER);
                }
                Iterator iter = root.elementIterator(E_OP);
                while (iter.hasNext()) {
                    org.dom4j.Element e = (org.dom4j.Element)iter.next();
                    String name = e.attributeValue(A_NAME);
                    if (name == null || name.length() == 0) {
                        ZimbraLog.system.warn("Operation ConfigLoader - cannot read name attribute for element " + e.toString());
                        continue;
                    }
                    int load = ConfigLoader.getAttrAsInt(e, A_LOAD, -1);
                    int maxLoad = ConfigLoader.getAttrAsInt(e, A_MAX_LOAD, -1);
                    int scale = ConfigLoader.getAttrAsInt(e, A_SCALE, -1);
                    Operation.Config newConfig = new Operation.Config();
                    newConfig.mLoad = load;
                    newConfig.mScale = scale;
                    newConfig.mMaxLoad = maxLoad;
                    if (Operation.mConfigMap.containsKey(name)) {
                        Operation.mConfigMap.remove(name);
                    }
                    Operation.mConfigMap.put(name, newConfig);
                }
            } else {
                ZimbraLog.system.warn("Operation ConfigLoader: local config file `" + cf + "' is not readable");
            }
        }
        catch (DocumentException e) {
            throw ServiceException.FAILURE("Caught document exception loading Operation Config file: " + configFile, e);
        }
    }

    private static int getAttrAsInt(org.dom4j.Element e, String attName, int defaultValue) {
        String s = e.attributeValue(attName, null);
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }
}

