/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.operation;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.operation.Operation;
import com.zimbra.cs.operation.Requester;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.session.Session;

public class BlockingOperation
extends Operation {
    private long mStart = 0L;
    private String mOperationName;

    public static final BlockingOperation schedule(String opName, Session session, OperationContext oc, Mailbox mbox, Requester req, Scheduler.Priority basePriority, int load) throws ServiceException {
        BlockingOperation toRet = new BlockingOperation(opName, session, oc, mbox, req, basePriority, load);
        toRet.start();
        return toRet;
    }

    private BlockingOperation(String opName, Session session, OperationContext oc, Mailbox mbox, Requester req, Scheduler.Priority basePriority, int load) {
        super(session, oc, mbox, req, basePriority, load);
        this.mOperationName = opName;
    }

    protected void callback() throws ServiceException {
    }

    public void schedule() throws ServiceException {
        throw ServiceException.FAILURE("Cannot schedule() a BlockingOperation", null);
    }

    protected String getClassName() {
        return this.mOperationName;
    }

    public void start() throws ServiceException {
        assert (this.mMailbox == null || !Thread.holdsLock(this.mMailbox));
        if (ZimbraLog.op.isDebugEnabled()) {
            ZimbraLog.op.debug("Scheduling " + this.toSchedulingString());
        }
        this.mSched = Scheduler.get(this.mMailbox);
        this.mSched.schedule(this);
        if (this.mSession != null) {
            this.mSession.logOperation(this);
        }
        if (ZimbraLog.op.isInfoEnabled()) {
            this.mStart = System.currentTimeMillis();
        }
        if (ZimbraLog.op.isDebugEnabled()) {
            ZimbraLog.op.debug("Executing:  " + this.toExecutingString());
        }
    }

    public void finish() {
        this.mSched.runCompleted(this);
        if (ZimbraLog.op.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            ZimbraLog.op.info("Completed(" + (end - this.mStart) + "ms): " + this.toCompletedString());
        }
    }
}

