/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.object;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.object.MatchedObject;
import com.zimbra.cs.object.ObjectHandlerException;
import com.zimbra.cs.zimlet.ZimletConfig;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletHandler;
import com.zimbra.cs.zimlet.ZimletUtil;
import java.util.ArrayList;
import java.util.List;

public class ObjectHandler {
    private static Log mLog = LogFactory.getLog(ObjectHandler.class);
    private static List<ObjectHandler> mHandlerList;
    private Zimlet mObjectType;
    private ZimletHandler mHandlerObject;
    private ZimletConfig mConfigObject;

    private ObjectHandler(Zimlet obj) throws ObjectHandlerException, ZimletException {
        this.mObjectType = obj;
        this.mHandlerObject = ZimletUtil.getHandler(obj.getName());
        if (this.mHandlerObject == null) {
            throw new ObjectHandlerException("null handler for " + obj.getType());
        }
        this.mConfigObject = new ZimletConfig(obj.getHandlerConfig());
        String regex = obj.getServerIndexRegex();
        if (regex != null) {
            this.mConfigObject.setRegExValue(regex);
        }
    }

    public static synchronized List getObjectHandlers() throws ServiceException {
        if (mHandlerList != null) {
            return mHandlerList;
        }
        mHandlerList = new ArrayList<ObjectHandler>();
        List<Zimlet> dots = Provisioning.getInstance().getObjectTypes();
        for (Zimlet dot : dots) {
            ObjectHandler handler = ObjectHandler.loadHandler(dot);
            if (handler == null) continue;
            mHandlerList.add(handler);
        }
        return mHandlerList;
    }

    private static synchronized ObjectHandler loadHandler(Zimlet dot) {
        ObjectHandler handler;
        block3: {
            handler = null;
            String clazz = dot.getHandlerClassName();
            if (clazz == null) {
                return null;
            }
            try {
                handler = new ObjectHandler(dot);
            }
            catch (Exception e) {
                if (!mLog.isErrorEnabled()) break block3;
                mLog.error((Object)"loadHandler caught exception", e);
            }
        }
        return handler;
    }

    public void parse(String text, List matchedObjects, boolean firstMatchOnly) throws ObjectHandlerException {
        try {
            String[] matchedStrings = this.mHandlerObject.match(text, this.mConfigObject);
            for (int i = 0; i < matchedStrings.length; ++i) {
                MatchedObject mo = new MatchedObject(this, matchedStrings[i]);
                matchedObjects.add(mo);
                if (!firstMatchOnly) continue;
                return;
            }
        }
        catch (ZimletException ze) {
            throw new ObjectHandlerException("error running ZimletHandler " + this.mObjectType.getType(), ze);
        }
    }

    public String getType() {
        return this.mObjectType.getType();
    }

    public String getHandlerConfig() {
        return this.mObjectType.getHandlerConfig();
    }

    public String getDescription() {
        return this.mObjectType.getDescription();
    }

    public boolean isIndexingEnabled() {
        return this.mObjectType.isIndexingEnabled();
    }
}

