/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import org.apache.mina.common.ByteBuffer;

public final class MinaUtil {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DOT = 46;
    public static final int INITIAL_CAPACITY = 32;

    public static java.nio.ByteBuffer expand(java.nio.ByteBuffer bb, int minSize, int maxSize) {
        if (maxSize != -1 && maxSize < minSize) {
            throw new IllegalArgumentException("maxSize < minSize");
        }
        if (bb == null) {
            int size = Math.max(minSize, 32);
            if (maxSize != -1 && size > maxSize) {
                size = maxSize;
            }
            return java.nio.ByteBuffer.allocate(size);
        }
        if (bb.remaining() >= minSize) {
            return bb;
        }
        int capacity = Math.max(bb.capacity() * 3 / 2 + 1, bb.position() + minSize);
        if (maxSize != -1) {
            capacity = Math.max(capacity, bb.position() + maxSize);
        }
        java.nio.ByteBuffer tmp = java.nio.ByteBuffer.allocate(capacity);
        bb.flip();
        return tmp.put(bb);
    }

    public static java.nio.ByteBuffer expand(java.nio.ByteBuffer bb, int minSize) {
        return MinaUtil.expand(bb, minSize, -1);
    }

    public static String toAsciiString(java.nio.ByteBuffer bb) {
        int len = bb.remaining();
        char[] cs = new char[len];
        for (int i = 0; i < len; ++i) {
            cs[i] = (char)(bb.get(i) & 0xFF);
        }
        return new String(cs);
    }

    public static java.nio.ByteBuffer toAsciiBytes(String s) {
        return MinaUtil.put(java.nio.ByteBuffer.allocate(s.length()), s);
    }

    public static java.nio.ByteBuffer put(java.nio.ByteBuffer bb, String s) {
        bb = MinaUtil.expand(bb, s.length());
        for (int i = 0; i < s.length(); ++i) {
            bb.put(i, (byte)s.charAt(i));
        }
        return bb;
    }

    public static byte[] getBytes(java.nio.ByteBuffer bb) {
        byte[] b;
        if (bb.hasArray() && bb.arrayOffset() == 0 && bb.position() == 0 && (b = bb.array()).length == bb.limit()) {
            return b;
        }
        b = new byte[bb.limit() - bb.position()];
        bb.duplicate().get(b);
        return b;
    }

    public static ByteBuffer toMinaByteBuffer(java.nio.ByteBuffer bb) {
        return ByteBuffer.wrap((java.nio.ByteBuffer)bb);
    }

    public static String toHexString(java.nio.ByteBuffer bb) {
        return MinaUtil.appendHex(new StringBuilder(), bb).toString();
    }

    public static StringBuilder appendHex(StringBuilder sb, java.nio.ByteBuffer bb) {
        int limit = bb.limit();
        for (int i = bb.position(); i < limit; ++i) {
            int c = bb.get(i) & 0xFF;
            sb.append(Character.forDigit(c >> 4, 16));
            sb.append(Character.forDigit(c & 0xF, 16));
            if (i >= limit - 1) continue;
            sb.append(' ');
        }
        return sb;
    }
}

