/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class MinaThreadFactory
implements ThreadFactory {
    private final ThreadGroup mGroup;
    private final AtomicInteger mThreadCount = new AtomicInteger(1);
    private final String mPrefix;

    public MinaThreadFactory(String prefix) {
        SecurityManager sm = System.getSecurityManager();
        this.mPrefix = prefix + "-";
        this.mGroup = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.mGroup, r, this.mPrefix + this.mThreadCount.getAndIncrement());
        t.setDaemon(false);
        t.setPriority(5);
        return t;
    }
}

