/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.cs.mina.MinaServer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.IoSession;

public class MinaStats {
    private final MinaServer server;
    public final AtomicLong totalSessions = new AtomicLong();
    public final AtomicLong activeSessions = new AtomicLong();
    public final AtomicLong receivedBytes = new AtomicLong();
    public final AtomicLong sentBytes = new AtomicLong();

    public MinaStats(MinaServer server) {
        this.server = server;
    }

    public long getTotalSessions() {
        return this.totalSessions.get();
    }

    public long getActiveSessions() {
        return this.activeSessions.get();
    }

    public long getReceivedBytes() {
        return this.receivedBytes.get();
    }

    public long getSentBytes() {
        return this.sentBytes.get();
    }

    public long getScheduledWriteBytes() {
        long total = 0L;
        for (IoSession session : this.server.getSessions()) {
            total += (long)session.getScheduledWriteBytes();
        }
        return total;
    }
}

