/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.NetUtil;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaIoHandler;
import com.zimbra.cs.mina.MinaLoggingFilter;
import com.zimbra.cs.mina.MinaStats;
import com.zimbra.cs.mina.MinaThreadFactory;
import com.zimbra.cs.security.sasl.SaslFilter;
import com.zimbra.cs.server.Server;
import com.zimbra.cs.server.ServerConfig;
import com.zimbra.cs.util.Zimbra;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.security.sasl.SaslServer;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MinaServer
implements Server {
    protected final ServerSocketChannel mChannel;
    protected final SocketAcceptorConfig mAcceptorConfig;
    protected final ExecutorService mHandlerThreadPool;
    protected final SocketAcceptor mSocketAcceptor;
    protected final ServerConfig mServerConfig;
    protected final MinaStats mStats;
    private static SSLContext sslContext;
    private static String[] mSslEnabledCipherSuites;
    private static final String HANDLER_THREAD_NAME = "MinaProtocolHandler";
    private static final int NUM_IO_PROCESSORS;
    private static final ExecutorService IO_THREAD_POOL;

    private static synchronized SSLContext getSSLContext() {
        if (sslContext == null) {
            try {
                sslContext = MinaServer.initSSLContext();
            }
            catch (Exception e) {
                Zimbra.halt("exception initializing SSL context", e);
            }
        }
        return sslContext;
    }

    private static SSLContext initSSLContext() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        char[] pass = LC.mailboxd_keystore_password.value().toCharArray();
        ks.load(new FileInputStream(LC.mailboxd_keystore.value()), pass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, pass);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return context;
    }

    private static synchronized String[] getSSLEnabledCiphers(SSLContext sslCtxt, ServerConfig serverConfig) {
        if (mSslEnabledCipherSuites == null) {
            try {
                String[] excludeCiphers = serverConfig.getSSLExcludeCiphers();
                if (excludeCiphers != null && excludeCiphers.length > 0) {
                    SSLEngine sslEng = sslCtxt.createSSLEngine();
                    String[] enabledCiphers = sslEng.getEnabledCipherSuites();
                    mSslEnabledCipherSuites = NetUtil.computeEnabledCipherSuites(enabledCiphers, excludeCiphers);
                }
                if (mSslEnabledCipherSuites == null) {
                    mSslEnabledCipherSuites = new String[0];
                }
            }
            catch (Exception e) {
                Zimbra.halt("exception initializing SSL enabled ciphers", e);
            }
        }
        return mSslEnabledCipherSuites;
    }

    private static SSLFilter getSSLFilter(ServerConfig serverConfig) {
        SSLContext sslCtxt = MinaServer.getSSLContext();
        SSLFilter sslFilter = new SSLFilter(sslCtxt);
        String[] enabledCiphers = MinaServer.getSSLEnabledCiphers(sslCtxt, serverConfig);
        if (enabledCiphers.length > 0) {
            sslFilter.setEnabledCipherSuites(enabledCiphers);
        }
        return sslFilter;
    }

    protected MinaServer(ServerConfig config, ExecutorService pool) throws IOException, ServiceException {
        this.mServerConfig = config;
        this.mHandlerThreadPool = pool;
        this.mChannel = config.getServerSocketChannel();
        this.mAcceptorConfig = new SocketAcceptorConfig();
        this.mAcceptorConfig.setReuseAddress(true);
        this.mAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
        this.mSocketAcceptor = new SocketAcceptor(NUM_IO_PROCESSORS, (Executor)IO_THREAD_POOL);
        this.mStats = new MinaStats(this);
    }

    protected MinaServer(ServerConfig config) throws IOException, ServiceException {
        this(config, Executors.newFixedThreadPool(config.getNumThreads(), new MinaThreadFactory(HANDLER_THREAD_NAME)));
    }

    public MinaStats getStats() {
        return this.mStats;
    }

    @Override
    public ServerConfig getConfig() {
        return this.mServerConfig;
    }

    @Override
    public void start() throws IOException {
        ServerConfig sc = this.getConfig();
        DefaultIoFilterChainBuilder fc = this.mAcceptorConfig.getFilterChain();
        if (sc.isSSLEnabled()) {
            fc.addFirst("ssl", (IoFilter)MinaServer.getSSLFilter(this.getConfig()));
        }
        fc.addLast("codec", (IoFilter)new ProtocolCodecFilter(this.getProtocolCodecFactory()));
        fc.addLast("executer", (IoFilter)new ExecutorFilter((Executor)this.mHandlerThreadPool));
        fc.addLast("logger", (IoFilter)new MinaLoggingFilter(this, false));
        MinaIoHandler handler = new MinaIoHandler(this);
        this.mSocketAcceptor.register(this.mChannel, (IoHandler)handler, (IoServiceConfig)this.mAcceptorConfig);
        this.getLog().info("Starting listener on %s%s", this.mChannel.socket().getLocalSocketAddress(), sc.isSSLEnabled() ? " (SSL)" : "");
    }

    @Override
    public void shutdown(int graceSecs) {
        this.getLog().info("Initiating shutdown");
        long start = System.currentTimeMillis();
        long graceMSecs = graceSecs * 1000;
        this.closeSessions(graceMSecs);
        this.mSocketAcceptor.unbind(this.getSocketAddress());
        this.mHandlerThreadPool.shutdown();
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > graceMSecs) {
            try {
                this.mHandlerThreadPool.awaitTermination(graceMSecs - elapsed, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.mHandlerThreadPool.shutdownNow();
    }

    private void closeSessions(long timeout) {
        ArrayList<MinaHandler> handlers = new ArrayList<MinaHandler>();
        for (IoSession session : this.getSessions()) {
            this.getLog().info("Closing session = " + session);
            MinaHandler handler = MinaIoHandler.getMinaHandler(session);
            if (handler == null) continue;
            handlers.add(handler);
        }
        long start = System.currentTimeMillis();
        for (MinaHandler handler : handlers) {
            long elapsed = System.currentTimeMillis() - start;
            try {
                handler.dropConnection(timeout - elapsed);
            }
            catch (IOException e) {
                this.getLog().warn("Error closing handler: %s", (Object)handler, e);
            }
        }
    }

    public Set<IoSession> getSessions() {
        return this.mSocketAcceptor.getManagedSessions(this.getSocketAddress());
    }

    private SocketAddress getSocketAddress() {
        return this.mChannel.socket().getLocalSocketAddress();
    }

    public static void startTLS(IoSession session, ServerConfig serverConfig) {
        SSLFilter filter = MinaServer.getSSLFilter(serverConfig);
        session.getFilterChain().addFirst("ssl", (IoFilter)filter);
        session.setAttribute(SSLFilter.DISABLE_ENCRYPTION_ONCE, (Object)true);
    }

    public static void addSaslFilter(IoSession session, SaslServer server) {
        SaslFilter filter = new SaslFilter(server);
        session.getFilterChain().addFirst("sasl", (IoFilter)filter);
        session.setAttribute(SaslFilter.DISABLE_ENCRYPTION_ONCE, (Object)true);
    }

    protected abstract MinaHandler createHandler(IoSession var1);

    protected abstract ProtocolCodecFactory getProtocolCodecFactory();

    public abstract Log getLog();

    static {
        NUM_IO_PROCESSORS = Runtime.getRuntime().availableProcessors() + 1;
        IO_THREAD_POOL = Executors.newCachedThreadPool(new MinaThreadFactory("MinaIoProcessorThread"));
    }
}

