/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class MinaOutputStream
extends OutputStream {
    private final int mSize;
    private ByteBuffer mBuffer;
    private boolean mClosed;

    public MinaOutputStream(int size) {
        this.mSize = size;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mClosed) {
            throw new IOException("Stream has been closed");
        }
        while (len > 0) {
            if (this.mBuffer == null) {
                this.mBuffer = ByteBuffer.allocate(Math.max(len, this.mSize));
            }
            int count = Math.min(len, this.mBuffer.remaining());
            this.mBuffer.put(b, off, count);
            if (!this.mBuffer.hasRemaining()) {
                this.flushBytes();
            }
            len -= count;
            off += count;
        }
    }

    public synchronized void write(String s) throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream has been closed");
        }
        int off = 0;
        int len = s.length();
        while (len > 0) {
            if (this.mBuffer == null) {
                this.mBuffer = ByteBuffer.allocate(Math.max(len, this.mSize));
            }
            int count = Math.min(len, this.mBuffer.remaining());
            len -= count;
            while (count-- > 0) {
                this.mBuffer.put((byte)s.charAt(off++));
            }
            if (this.mBuffer.hasRemaining()) continue;
            this.flushBytes();
        }
    }

    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public synchronized void flush() throws IOException {
        if (!this.mClosed) {
            this.flushBytes();
        }
    }

    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            this.flushBytes();
            this.mClosed = true;
        }
    }

    private void flushBytes() throws IOException {
        if (this.mBuffer == null || this.mBuffer.position() <= 0) {
            return;
        }
        this.mBuffer.flip();
        this.flushBytes(this.mBuffer);
        this.mBuffer = null;
    }

    protected abstract void flushBytes(ByteBuffer var1) throws IOException;

    public abstract boolean join(long var1);
}

