/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mina.MinaServer;
import com.zimbra.cs.mina.MinaUtil;
import java.net.SocketException;
import javax.net.ssl.SSLException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;

class MinaLoggingFilter
extends IoFilterAdapter {
    private final Log mLog;
    private final boolean mHexDump;

    MinaLoggingFilter(MinaServer server, boolean hexDump) {
        this.mLog = server.getLog();
        this.mHexDump = hexDump;
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        this.debug(session, "Session created");
        nextFilter.sessionCreated(session);
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        this.debug(session, "Connection opened");
        nextFilter.sessionOpened(session);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        this.debug(session, "Connection closed");
        nextFilter.sessionClosed(session);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        if (this.mLog.isDebugEnabled()) {
            this.debug(session, "Connection idle: " + status);
        }
        nextFilter.sessionIdle(session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        ZimbraLog.addIpToContext(session.getRemoteAddress().toString());
        String msg = "Exception caught: " + cause;
        if (MinaLoggingFilter.isSocketError(cause)) {
            if (this.mLog.isDebugEnabled()) {
                this.mLog.info((Object)msg, cause);
            } else {
                this.mLog.info(msg);
            }
        } else {
            this.mLog.error((Object)msg, cause);
        }
        nextFilter.exceptionCaught(session, cause);
    }

    private static boolean isSocketError(Throwable e) {
        return e instanceof SocketException || e instanceof SSLException;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (this.mLog.isDebugEnabled()) {
            this.debug(session, "Message received: " + this.pp(message));
        }
        nextFilter.messageReceived(session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (this.mLog.isDebugEnabled()) {
            this.debug(session, "Message sent: " + this.pp(message));
        }
        nextFilter.messageSent(session, message);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) {
        if (this.mLog.isDebugEnabled()) {
            this.debug(session, "Message written: " + this.pp(writeRequest));
        }
        nextFilter.filterWrite(session, writeRequest);
    }

    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.debug(session, "Connection closed by client");
        nextFilter.filterClose(session);
    }

    private Object pp(Object msg) {
        java.nio.ByteBuffer bb;
        if (msg instanceof IoFilter.WriteRequest) {
            return this.pp(((IoFilter.WriteRequest)msg).getMessage());
        }
        if (msg instanceof String) {
            return msg;
        }
        if (msg instanceof java.nio.ByteBuffer) {
            bb = (java.nio.ByteBuffer)msg;
        } else if (msg instanceof ByteBuffer) {
            bb = ((ByteBuffer)msg).buf();
        } else if (msg instanceof byte[]) {
            bb = java.nio.ByteBuffer.wrap((byte[])msg);
        } else {
            return msg;
        }
        return this.isPrintable(bb) ? this.pp(bb) : msg;
    }

    private boolean isPrintable(java.nio.ByteBuffer bb) {
        int limit = bb.limit();
        for (int i = bb.position(); i < limit; ++i) {
            if (MinaLoggingFilter.isPrintable(bb.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintable(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return b > 31 && b < 127;
    }

    private String pp(java.nio.ByteBuffer bb) {
        StringBuilder sb = new StringBuilder(bb.remaining());
        if (this.mHexDump) {
            sb = MinaUtil.appendHex(sb.append('('), bb).append(") ");
        }
        int limit = bb.limit();
        for (int i = bb.position(); i < limit; ++i) {
            sb.append((char)(bb.get(i) & 0xFF));
        }
        return sb.toString();
    }

    private void debug(IoSession session, String msg) {
        if (this.mLog.isDebugEnabled()) {
            ZimbraLog.addIpToContext(session.getRemoteAddress().toString());
            this.mLog.debug(msg);
        }
    }
}

