/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.cs.mina.MinaOutputStream;
import com.zimbra.cs.mina.MinaUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class MinaIoSessionOutputStream
extends MinaOutputStream {
    private final IoSession session;
    private WriteFuture lowWatermarkFuture;
    private WriteFuture lastFuture;
    private int lowWatermark;
    private int highWatermark;
    private long timeout;

    public MinaIoSessionOutputStream(IoSession session, int size) {
        super(size);
        this.session = session;
    }

    public MinaIoSessionOutputStream(IoSession session) {
        this(session, 8192);
    }

    public MinaIoSessionOutputStream setLowWatermark(int lowWatermark) {
        if (lowWatermark > this.highWatermark) {
            throw new IllegalArgumentException();
        }
        this.lowWatermark = lowWatermark;
        return this;
    }

    public MinaIoSessionOutputStream setHighWatermark(int highWatermark) {
        if (highWatermark < this.lowWatermark) {
            throw new IllegalArgumentException();
        }
        this.highWatermark = highWatermark;
        return this;
    }

    public MinaIoSessionOutputStream setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    protected void flushBytes(ByteBuffer bb) throws IOException {
        if (this.highWatermark > 0 && this.session.getScheduledWriteBytes() > this.highWatermark) {
            if (!this.join(this.lowWatermarkFuture, this.timeout)) {
                throw new IOException("Max write queue size exceeded - closing connection");
            }
            this.lowWatermarkFuture = null;
        }
        this.lastFuture = this.session.write((Object)MinaUtil.toMinaByteBuffer(bb));
        if (this.lowWatermark > 0 && this.session.getScheduledWriteBytes() > this.lowWatermark) {
            this.lowWatermarkFuture = this.lastFuture;
        }
    }

    public boolean join() {
        return this.join(this.timeout);
    }

    public boolean join(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        return this.join(this.lastFuture, timeout);
    }

    private boolean join(WriteFuture future, long timeout) {
        if (future == null) {
            return true;
        }
        if (timeout > 0L) {
            future.join(timeout);
        } else {
            future.join();
        }
        return future.isWritten();
    }
}

