/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaServer;
import com.zimbra.cs.mina.MinaStats;
import java.io.IOException;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;

class MinaIoHandler
implements IoHandler {
    private final MinaServer server;
    private final MinaStats stats;
    private static final String MINA_HANDLER_ATTR = "MinaHandler";

    MinaIoHandler(MinaServer server) {
        this.server = server;
        this.stats = server.getStats();
    }

    public void sessionCreated(IoSession session) throws IOException {
        session.setAttribute(MINA_HANDLER_ATTR, (Object)this.server.createHandler(session));
    }

    public void sessionOpened(IoSession session) throws IOException {
        MinaIoHandler.getMinaHandler(session).connectionOpened();
        if (this.stats != null) {
            this.stats.activeSessions.incrementAndGet();
            this.stats.totalSessions.incrementAndGet();
        }
    }

    public void sessionClosed(IoSession session) throws IOException {
        MinaIoHandler.getMinaHandler(session).connectionClosed();
        if (this.stats != null) {
            this.stats.activeSessions.decrementAndGet();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws IOException {
        MinaIoHandler.getMinaHandler(session).connectionIdle();
    }

    public void messageReceived(IoSession session, Object msg) throws IOException {
        MinaIoHandler.getMinaHandler(session).messageReceived(msg);
    }

    public void exceptionCaught(IoSession session, Throwable e) throws IOException {
        MinaIoHandler.getMinaHandler(session).connectionClosed();
    }

    public void messageSent(IoSession session, Object msg) {
    }

    public static MinaHandler getMinaHandler(IoSession session) {
        return (MinaHandler)session.getAttribute(MINA_HANDLER_ATTR);
    }
}

